/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay.box;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.gui.IMenuBuilder;
import net.kapitencraft.kap_lib.client.gui.screen.MenuableScreen;
import net.kapitencraft.kap_lib.client.overlay.OverlayManager;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.box.InteractiveBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.client.widget.menu.Menu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.ButtonElement;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.EnumElement;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class ResizeBox
extends InteractiveBox
implements IMenuBuilder {
    private final List<AccessBox> boxes = new ArrayList<AccessBox>();
    @NotNull
    private final Overlay dedicatedHolder;
    private static final int BOX_COLOR = -1;
    private static final int FILL_COLOR = 0x30FFFFFF;
    private AccessBox active;

    public ResizeBox(Vec2 start, Vec2 finish, @NotNull Overlay dedicatedHolder) {
        super(start, finish, 221193, 0x30FFFFFF);
        this.dedicatedHolder = dedicatedHolder;
        this.fillBoxes();
    }

    private void fillBoxes() {
        this.boxes.clear();
        for (Type type : Type.values()) {
            this.boxes.add(new AccessBox(type == Type.C ? 0x30FFFFFF : -1, type));
        }
        this.reapplyPosition();
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY) {
        this.boxes.forEach(resizeAccessBox -> resizeAccessBox.render(graphics, mouseX, mouseY));
    }

    @Override
    public int getCursorType(double mouseX, double mouseY) {
        return this.boxes.stream().filter(resizeAccessBox -> resizeAccessBox.m_5953_(mouseX, mouseY)).map(box -> box.getCursorType(mouseX, mouseY)).findFirst().orElse(this.getSelfCursor(mouseX, mouseY));
    }

    private int getSelfCursor(double mouseX, double mouseY) {
        int cursorId = 221185;
        if (this.m_5953_(mouseX, mouseY)) {
            cursorId = 221193;
        }
        return cursorId;
    }

    @Override
    public void move(Vec2 delta) {
        this.dedicatedHolder.move(delta);
        this.moveWithoutHolder(delta);
    }

    @Override
    public void moveX(float offset) {
        super.moveX(offset);
        this.dedicatedHolder.moveX(offset);
    }

    @Override
    public void moveY(float offset) {
        super.moveY(offset);
        this.dedicatedHolder.moveY(offset);
    }

    private void addX(float xChange) {
        this.end = new Vec2(this.end.f_82470_ + xChange, this.end.f_82471_);
    }

    private void addY(float yChange) {
        this.end = new Vec2(this.end.f_82470_, this.end.f_82471_ + yChange);
    }

    private void moveWithoutHolder(Vec2 delta) {
        super.move(delta);
        this.boxes.forEach(resizeAccessBox -> resizeAccessBox.move(delta));
    }

    protected void reapplyPosition() {
        this.boxes.forEach(AccessBox::reapplyPosition);
    }

    @Override
    public boolean m_5953_(double x, double y) {
        return super.m_5953_(x, y) || this.boxes.stream().anyMatch(resizeAccessBox -> resizeAccessBox.m_5953_(x, y));
    }

    @Override
    public boolean mouseDrag(double x, double y, int clickType, double xChange, double yChange, double oldX, double oldY) {
        if (this.active == null) {
            return false;
        }
        Type type = this.active.getType();
        if (type == Type.C) {
            this.move(new Vec2((float)xChange, (float)yChange));
        } else {
            Boolean xOffset = this.active.getType().axes.get((Object)Axis.X);
            Boolean yOffset = this.active.getType().axes.get((Object)Axis.Y);
            if (xOffset != null) {
                if (xOffset.booleanValue()) {
                    this.moveX((float)xChange);
                } else {
                    this.addX((float)xChange);
                }
                float width = this.width();
                float scaleX = (float)(((double)width + (xOffset != false ? -xChange : xChange)) / (double)width);
                this.dedicatedHolder.getProperties().scaleX(scaleX);
            }
            if (yOffset != null) {
                if (yOffset.booleanValue()) {
                    this.moveY((float)yChange);
                } else {
                    this.addY((float)yChange);
                }
                float height = this.height();
                float scaleY = (float)(((double)height + (yOffset != false ? -yChange : yChange)) / (double)height);
                this.dedicatedHolder.getProperties().scaleY(scaleY);
            }
        }
        this.reapplyPosition();
        return true;
    }

    protected Type getType() {
        return this.active.getType();
    }

    @Override
    public void mouseRelease(double x, double y) {
        this.active = null;
    }

    private void setActive(AccessBox box) {
        this.active = box;
    }

    @Override
    public Menu createMenu(int x, int y, MenuableScreen screen) {
        DropDownMenu menu = new DropDownMenu(x, y, this);
        OverlayProperties properties = this.dedicatedHolder.getProperties();
        menu.addElement(((EnumElement.Builder)EnumElement.builder(OverlayProperties.Alignment.class).setName((Component)Component.m_237115_((String)"gui.alignment.x"))).setCurrent(properties.getXAlignment()).setElements(OverlayProperties.Alignment.values()).setNameMapper(OverlayProperties.Alignment::getWidthName).setOnChange(properties::setXAlignment));
        menu.addElement(((EnumElement.Builder)EnumElement.builder(OverlayProperties.Alignment.class).setName((Component)Component.m_237115_((String)"gui.alignment.y"))).setCurrent(properties.getYAlignment()).setElements(OverlayProperties.Alignment.values()).setNameMapper(OverlayProperties.Alignment::getHeightName).setOnChange(properties::setYAlignment));
        menu.addElement(((ButtonElement.Builder)ButtonElement.builder().setName((Component)Component.m_237115_((String)"gui.reset_overlay"))).setExecutor(this::reset));
        menu.addElement(((ButtonElement.Builder)ButtonElement.builder().setName((Component)Component.m_237115_((String)"gui.hide_overlay"))).setExecutor(() -> {
            OverlayManager.setVisible(this.dedicatedHolder, false);
            properties.hide();
            menu.hide(screen);
            screen.closeMenu();
        }));
        return menu;
    }

    private void reset() {
        OverlayManager controller = LibClient.overlays;
        controller.reset(this.dedicatedHolder);
        this.dedicatedHolder.reset(ClientHelper.getScreenWidth(), ClientHelper.getScreenHeight(), Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91062_, this);
        this.reapplyPosition();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            Optional<AccessBox> optional = this.boxes.stream().filter(accessBox -> accessBox.m_5953_(pMouseX, pMouseY)).findFirst();
            optional.ifPresent(this::setActive);
            return optional.isPresent();
        }
        return pButton == 1 && this.m_5953_(pMouseX, pMouseY);
    }

    public int getActiveArrowId() {
        return this.active == null ? 221185 : this.active.getCursorType();
    }

    public static enum Type {
        N(Map.of(Axis.Y, true)),
        NE(Map.of(Axis.Y, true, Axis.X, false)),
        E(Map.of(Axis.X, false)),
        SE(Map.of(Axis.Y, false, Axis.X, false)),
        S(Map.of(Axis.Y, false)),
        SW(Map.of(Axis.Y, false, Axis.X, true)),
        W(Map.of(Axis.X, true)),
        NW(Map.of(Axis.Y, true, Axis.X, false)),
        C(Map.of());

        private final Map<Axis, Boolean> axes;

        private Type(Map<Axis, Boolean> map) {
            this.axes = map;
        }
    }

    private class AccessBox
    extends InteractiveBox {
        private final Type type;
        private static final float LINE_WIDTH = 0.5f;
        private static final float SQUARE_SIZE = 1.5f;

        protected AccessBox(Vec2 start, Vec2 finish, int cursorType, int color, Type type) {
            super(start, finish, cursorType, color);
            this.type = type;
        }

        protected AccessBox(int color, Type type) {
            this(Vec2.f_82462_, Vec2.f_82462_, AccessBox.getCursorType(type), color, type);
        }

        protected Type getType() {
            return this.type;
        }

        public static int getCursorType(Type type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Type.E, Type.W -> 221189;
                case Type.N, Type.S -> 221190;
                case Type.NW, Type.SE -> 221191;
                case Type.NE, Type.SW -> 221192;
                case Type.C -> 221193;
            };
        }

        public int getCursorType() {
            return AccessBox.getCursorType(this.type);
        }

        protected void reapplyPosition() {
            Vec2 start = ResizeBox.this.start;
            Vec2 end = ResizeBox.this.end;
            Vec2 bottomLeft = new Vec2(start.f_82470_, end.f_82471_);
            Vec2 topRight = new Vec2(end.f_82470_, start.f_82471_);
            switch (this.type) {
                case E: {
                    this.applyLine(topRight, end, 0.5f);
                    break;
                }
                case SE: {
                    this.applySquare(end, 1.5f);
                    break;
                }
                case S: {
                    this.applyLine(bottomLeft, end, 0.5f);
                    break;
                }
                case SW: {
                    this.applySquare(bottomLeft, 1.5f);
                    break;
                }
                case W: {
                    this.applyLine(start, bottomLeft, 0.5f);
                    break;
                }
                case NW: {
                    this.applySquare(start, 1.5f);
                    break;
                }
                case N: {
                    this.applyLine(start, topRight, 0.5f);
                    break;
                }
                case NE: {
                    this.applySquare(topRight, 1.5f);
                    break;
                }
                case C: {
                    this.start = start.m_165908_(0.5f);
                    this.end = end.m_165908_(-0.5f);
                }
            }
        }

        public void applyLine(Vec2 start, Vec2 finish, float lineW) {
            boolean horizontal = start.f_82470_ == finish.f_82470_;
            this.start = new Vec2(horizontal ? start.f_82470_ - lineW : start.f_82470_, horizontal ? start.f_82471_ : start.f_82471_ - lineW);
            this.end = new Vec2(horizontal ? finish.f_82470_ + lineW : finish.f_82470_, horizontal ? finish.f_82471_ : finish.f_82471_ + lineW);
        }

        public void applySquare(Vec2 center, float size) {
            this.start = center.m_165910_(new Vec2(-size, -size));
            this.end = center.m_165910_(new Vec2(size, size));
        }
    }

    private static enum Axis {
        X,
        Y;

    }
}

