/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.kapitencraft.kap_lib.registry.ExtraParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DamageIndicatorParticleOptions
extends ParticleType<DamageIndicatorParticleOptions>
implements ParticleOptions {
    private static final Codec<DamageIndicatorParticleOptions> CODEC = RecordCodecBuilder.create(optionsInstance -> optionsInstance.group((App)Codec.INT.fieldOf("damageType").forGetter(DamageIndicatorParticleOptions::getDamageType), (App)Codec.FLOAT.fieldOf("damage").forGetter(DamageIndicatorParticleOptions::getDamage), (App)Codec.FLOAT.fieldOf("rangeOffset").forGetter(DamageIndicatorParticleOptions::getRangeOffset)).apply((Applicative)optionsInstance, DamageIndicatorParticleOptions::new));
    private final int damageType;
    private final float damage;
    private final float rangeOffset;

    public DamageIndicatorParticleOptions(int damageType, float damage, float rangeOffset) {
        super(true, (ParticleOptions.Deserializer)new Deserializer());
        this.damageType = damageType;
        this.damage = damage;
        this.rangeOffset = rangeOffset;
    }

    public int getDamageType() {
        return this.damageType;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getRangeOffset() {
        return this.rangeOffset;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ExtraParticleTypes.DAMAGE_INDICATOR.get();
    }

    public void m_7711_(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.damageType);
        buf.writeFloat(this.damage);
        buf.writeFloat(this.rangeOffset);
    }

    @NotNull
    public String m_5942_() {
        return String.format("%s %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.damageType);
    }

    @NotNull
    public Codec<DamageIndicatorParticleOptions> m_7652_() {
        return CODEC;
    }

    public static class Deserializer
    implements ParticleOptions.Deserializer<DamageIndicatorParticleOptions> {
        @NotNull
        public DamageIndicatorParticleOptions fromCommand(@NotNull ParticleType<DamageIndicatorParticleOptions> p_123733_, @NotNull StringReader reader) throws CommandSyntaxException {
            int damageType = reader.readInt();
            reader.expect(' ');
            float damage = reader.readFloat();
            reader.expect(' ');
            float rangeOffset = reader.readFloat();
            return new DamageIndicatorParticleOptions(damageType, damage, rangeOffset);
        }

        @NotNull
        public DamageIndicatorParticleOptions fromNetwork(@NotNull ParticleType<DamageIndicatorParticleOptions> p_123735_, @NotNull FriendlyByteBuf buf) {
            int damageType = buf.readInt();
            float damage = buf.readFloat();
            float rangeOffset = buf.readFloat();
            return new DamageIndicatorParticleOptions(damageType, damage, rangeOffset);
        }
    }
}

