/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.kapitencraft.kap_lib.registry.ExtraParticleTypes;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class ShimmerShieldParticleOptions
extends ParticleType<ShimmerShieldParticleOptions>
implements ParticleOptions {
    private static final Codec<ShimmerShieldParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("minLifeTime").forGetter(ShimmerShieldParticleOptions::getMinLifeTime), (App)Codec.INT.fieldOf("maxElements").forGetter(ShimmerShieldParticleOptions::getMaxElements), (App)Codec.INT.fieldOf("entityId").forGetter(ShimmerShieldParticleOptions::getEntityId), (App)Codec.INT.fieldOf("minRegenTime").forGetter(ShimmerShieldParticleOptions::getMinRegenTime), (App)Codec.INT.fieldOf("maxRegenTime").forGetter(ShimmerShieldParticleOptions::getMaxRegenTime), (App)Codec.INT.fieldOf("maxLifeTime").forGetter(ShimmerShieldParticleOptions::getMaxLifeTime), (App)Color.CODEC.fieldOf("minColor").forGetter(ShimmerShieldParticleOptions::getMinColor), (App)Color.CODEC.fieldOf("maxColor").forGetter(ShimmerShieldParticleOptions::getMaxColor), (App)Codec.FLOAT.fieldOf("maxSpeed").forGetter(ShimmerShieldParticleOptions::getMaxSpeed), (App)UUIDUtil.f_260719_.fieldOf("uuid").forGetter(ShimmerShieldParticleOptions::getUUID)).apply((Applicative)instance, ShimmerShieldParticleOptions::new));
    private final int minLifeTime;
    private final int maxElements;
    private final int entityId;
    private final int minRegenTime;
    private final int maxRegenTime;
    private final int maxLifeTime;
    private final Color min;
    private final Color max;
    private final float maxSpeed;
    private final UUID uuid;

    public ShimmerShieldParticleOptions(int minLifeTime, int maxElements, int entityId, int minRegenTime, int maxRegenTime, int maxLifeTime, Color min, Color max, float maxSpeed, UUID uuid) {
        super(true, (ParticleOptions.Deserializer)new Deserializer());
        this.minLifeTime = minLifeTime;
        this.maxElements = maxElements;
        this.entityId = entityId;
        this.minRegenTime = minRegenTime;
        this.maxRegenTime = maxRegenTime;
        this.maxLifeTime = maxLifeTime;
        this.min = min;
        this.max = max;
        this.maxSpeed = maxSpeed;
        this.uuid = uuid;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ExtraParticleTypes.SHIMMER_SHIELD.get();
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        pBuffer.writeInt(this.minLifeTime);
        pBuffer.writeInt(this.maxElements);
        pBuffer.writeInt(this.entityId);
        pBuffer.writeInt(this.minRegenTime);
        pBuffer.writeInt(this.maxRegenTime);
        pBuffer.writeInt(this.maxLifeTime);
        this.min.write(pBuffer);
        this.max.write(pBuffer);
        pBuffer.writeFloat(this.maxSpeed);
        pBuffer.m_130077_(this.uuid);
    }

    public String m_5942_() {
        return "";
    }

    public Codec<ShimmerShieldParticleOptions> m_7652_() {
        return CODEC;
    }

    public int getMinLifeTime() {
        return this.minLifeTime;
    }

    public Color getMinColor() {
        return this.min;
    }

    public Color getMaxColor() {
        return this.max;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getMaxElements() {
        return this.maxElements;
    }

    public int getMinRegenTime() {
        return this.minRegenTime;
    }

    public int getMaxRegenTime() {
        return this.maxRegenTime;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public UUID getUUID() {
        return null;
    }

    private static class Deserializer
    implements ParticleOptions.Deserializer<ShimmerShieldParticleOptions> {
        private Deserializer() {
        }

        public ShimmerShieldParticleOptions fromCommand(ParticleType<ShimmerShieldParticleOptions> pParticleType, StringReader pReader) throws CommandSyntaxException {
            return null;
        }

        public ShimmerShieldParticleOptions fromNetwork(ParticleType<ShimmerShieldParticleOptions> pParticleType, FriendlyByteBuf pBuffer) {
            int minLifeTime = pBuffer.readInt();
            int maxElements = pBuffer.readInt();
            int entityId = pBuffer.readInt();
            int minRegenTime = pBuffer.readInt();
            int maxRegenTime = pBuffer.readInt();
            int maxLifeTime = pBuffer.readInt();
            Color min = Color.read(pBuffer);
            Color max = Color.read(pBuffer);
            float maxSpeed = pBuffer.readFloat();
            UUID uuid = pBuffer.m_130259_();
            return new ShimmerShieldParticleOptions(minLifeTime, maxElements, entityId, minRegenTime, maxRegenTime, maxLifeTime, min, max, maxSpeed, uuid);
        }
    }
}

