/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import java.util.List;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.VisibleSpawner;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LineSpawner
extends VisibleSpawner {
    private final PositionTarget start;
    private final PositionTarget end;
    private final float spacing;

    public LineSpawner(ParticleOptions options, PositionTarget start, PositionTarget end, float spacing) {
        super(options);
        this.start = start;
        this.end = end;
        this.spacing = spacing;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        List<Vec3> positions = MathHelper.makeLine(this.start.get(), this.end.get(), this.spacing);
        positions.forEach(v -> sink.accept(this.particle, (Vec3)v));
    }

    @NotNull
    public Type getType() {
        return (Type)SpawnerTypes.LINE.get();
    }

    public String toString() {
        return "LineSpawner from " + this.start + " to " + this.end + ", spacing = " + this.spacing;
    }

    public static class Builder
    extends VisibleSpawner.Builder<Builder> {
        private PositionTarget start;
        private PositionTarget end;
        private float spacing;

        public Builder start(PositionTarget start) {
            this.start = start;
            return this;
        }

        public Builder end(PositionTarget end) {
            this.end = end;
            return this;
        }

        public Builder spacing(float spacing) {
            this.spacing = spacing;
            return this;
        }

        @Override
        public VisibleSpawner build() {
            return new LineSpawner(this.particle, this.start, this.end, this.spacing);
        }
    }

    public static class Type
    implements Spawner.Type<LineSpawner> {
        @Override
        public void toNW(FriendlyByteBuf buf, LineSpawner value) {
            NetworkHelper.writeParticleOptions(buf, value.particle);
            value.start.toNw(buf);
            value.end.toNw(buf);
            buf.writeFloat(value.spacing);
        }

        @Override
        public LineSpawner fromNw(FriendlyByteBuf buf, ClientLevel level) {
            return new LineSpawner((ParticleOptions)NetworkHelper.readParticleOptions(buf), PositionTarget.fromNw(buf), PositionTarget.fromNw(buf), buf.readFloat());
        }
    }
}

