/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.cooldown.Cooldowns;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CooldownsProvider
implements ICapabilityProvider,
INBTSerializable<Tag> {
    private static final Codec<Map<Cooldown, Integer>> CODEC = Codec.unboundedMap((Codec)ExtraRegistries.COOLDOWNS.getCodec(), (Codec)Codec.INT);
    private final LazyOptional<Cooldowns> lazy;
    private final Cooldowns cooldowns;

    public CooldownsProvider(LivingEntity living) {
        this.cooldowns = new Cooldowns(living);
        this.lazy = LazyOptional.of(() -> this.cooldowns);
    }

    public Tag serializeNBT() {
        return (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.cooldowns.getData()).resultOrPartial(s -> KapLibMod.LOGGER.warn("error saving cooldowns {}", s)).orElse(new CompoundTag());
    }

    public void deserializeNBT(Tag nbt) {
        this.cooldowns.loadData(CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(s -> KapLibMod.LOGGER.warn("error loading cooldowns")).orElse(Map.of()));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return Cooldowns.CAPABILITY.orEmpty(cap, this.lazy);
    }
}

