/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.collection.DoubleMap;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.io.serialization.DataPackSerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.item.combat.armor.AbstractArmorItem;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BonusProvider
extends ItemTagsProvider {
    private final PackOutput output;
    private final String modId;
    private final Map<String, SetBuilder> setBuilders = new HashMap<String, SetBuilder>();
    private final DoubleMap<Item, String, ItemBuilder> itemBuilders = DoubleMap.create();

    public BonusProvider(PackOutput output, String modId, CompletableFuture<HolderLookup.Provider> pLookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, pLookupProvider, CompletableFuture.completedFuture(TagsProvider.TagLookup.m_274566_()), modId, existingFileHelper);
        this.output = output;
        this.modId = modId;
    }

    protected SetBuilder createSetBonus(String name) {
        this.setBuilders.putIfAbsent(name, new SetBuilder(name));
        return this.setBuilders.get(name);
    }

    protected ItemBuilder createItemBonus(Item item, String name) {
        ItemBuilder builder = new ItemBuilder();
        this.itemBuilders.putIfAbsent(item, name, builder);
        return builder;
    }

    protected ItemBuilder createItemBonus(Supplier<? extends Item> supplier, String name) {
        return this.createItemBonus(supplier.get(), name);
    }

    public abstract void register();

    @ApiStatus.Internal
    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput pOutput) {
        this.register();
        List<CompletableFuture> setExecutors = MapStream.of(this.setBuilders).mapToSimple((key, builder) -> {
            Path path = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("bonuses").resolve("set").resolve(key + ".json");
            return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)this.saveSet((SetBuilder)builder), (Path)path);
        }).toList();
        ArrayList itemExecutors = new ArrayList();
        this.itemBuilders.forAllEach((item, location, itemBuilder) -> {
            Path path = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("bonuses").resolve(location + ".json");
            itemExecutors.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)this.saveItem((Item)item, (ItemBuilder)itemBuilder), (Path)path));
        });
        return CompletableFuture.allOf(CompletableFuture.allOf((CompletableFuture[])setExecutors.toArray(CompletableFuture[]::new)), CompletableFuture.allOf((CompletableFuture[])itemExecutors.toArray(CompletableFuture[]::new)), super.m_213708_(pOutput));
    }

    private <T extends Bonus<T>> JsonObject saveItem(Item item, ItemBuilder itemBuilder) {
        Bonus<?> bonus = itemBuilder.getBonus();
        JsonObject main = new JsonObject();
        if (itemBuilder.isHidden()) {
            main.addProperty("hidden", Boolean.valueOf(true));
        }
        DataPackSerializer<?> serializer = bonus.getSerializer();
        main.add("data", (JsonElement)serializer.encode(bonus));
        if (item != null) {
            main.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item), "unknown item with class: " + item.getClass().getCanonicalName()).toString());
        }
        main.addProperty("type", Objects.requireNonNull(ExtraRegistries.BONUS_SERIALIZER.getKey(itemBuilder.bonus.getSerializer()), "unknown bonus with class: " + itemBuilder.bonus.getClass().getCanonicalName()).toString());
        return main;
    }

    private JsonObject saveSet(SetBuilder builder) {
        JsonObject main = this.saveItem(null, builder);
        JsonArray array = new JsonArray();
        for (EquipmentSlot slot : builder.equipmentContent.keySet()) {
            array.add(slot.m_20751_());
        }
        main.add("equipment_slots", (JsonElement)array);
        JsonArray wearables = new JsonArray();
        for (WearableSlot slot : builder.wearableContent.keySet()) {
            wearables.add(ExtraRegistries.WEARABLE_SLOTS.getKey((Object)slot).toString());
        }
        main.add("wearable_slots", (JsonElement)wearables);
        return main;
    }

    @NotNull
    public String m_6055_() {
        return "Bonuses of '" + this.modId + "'";
    }

    protected void m_6577_(@NotNull HolderLookup.Provider pProvider) {
        this.setBuilders.values().forEach(setBuilder -> {
            setBuilder.equipmentContent.values().forEach(setSlotBuilder -> this.f_126543_.put(setSlotBuilder.key.f_203868_(), setSlotBuilder.builder));
            setBuilder.wearableContent.values().forEach(setSlotBuilder -> this.f_126543_.put(setSlotBuilder.key.f_203868_(), setSlotBuilder.builder));
        });
    }

    protected class SetBuilder
    extends ItemBuilder {
        private final Map<EquipmentSlot, SetSlotBuilder> equipmentContent = new HashMap<EquipmentSlot, SetSlotBuilder>();
        private final Map<WearableSlot, SetSlotBuilder> wearableContent = new HashMap<WearableSlot, SetSlotBuilder>();
        private final String name;

        protected SetBuilder(String name) {
            this.name = name;
        }

        public SetBuilder slot(EquipmentSlot slot, Consumer<SetSlotBuilder> builder) {
            this.equipmentContent.putIfAbsent(slot, (SetSlotBuilder)Util.m_137469_((Object)new SetSlotBuilder(new ResourceLocation(BonusProvider.this.modId, "set/" + this.name + "/" + slot.m_20751_())), builder));
            return this;
        }

        public SetBuilder slot(EquipmentSlot slot, Item item) {
            return this.slot(slot, (SetSlotBuilder setSlotBuilder) -> setSlotBuilder.add(item));
        }

        public SetBuilder slot(EquipmentSlot slot, Supplier<? extends Item> supplier) {
            return this.slot(slot, supplier.get());
        }

        public SetBuilder armor(Map<ArmorItem.Type, ? extends RegistryObject<? extends AbstractArmorItem>> armors) {
            for (Map.Entry<ArmorItem.Type, ? extends RegistryObject<? extends AbstractArmorItem>> piece : armors.entrySet()) {
                EquipmentSlot slot = piece.getKey().m_266308_();
                this.slot(slot, (Supplier<? extends Item>)((Supplier)piece.getValue()));
            }
            return this;
        }

        public SetBuilder slot(WearableSlot slot, Consumer<SetSlotBuilder> builder) {
            ResourceLocation location = ExtraRegistries.WEARABLE_SLOTS.getKey((Object)slot);
            if (location == null) {
                throw new IllegalArgumentException("unregistered wearable slot detected!");
            }
            this.wearableContent.putIfAbsent(slot, (SetSlotBuilder)Util.m_137469_((Object)new SetSlotBuilder(new ResourceLocation(BonusProvider.this.modId, "set/" + this.name + "/wearable/" + location.m_135827_() + "/" + location.m_135815_())), builder));
            return this;
        }

        public SetBuilder slot(RegistryObject<WearableSlot> slot, Item item) {
            return this.slot(slot, (SetSlotBuilder setSlotBuilder) -> setSlotBuilder.add(item));
        }

        public SetBuilder slot(RegistryObject<WearableSlot> slot, Supplier<? extends Item> supplier) {
            return this.slot(slot, supplier.get());
        }

        public SetBuilder slot(RegistryObject<WearableSlot> slot, Consumer<SetSlotBuilder> builder) {
            ResourceLocation location = slot.getId();
            if (location == null) {
                throw new IllegalArgumentException("unregistered wearable slot detected!");
            }
            this.wearableContent.putIfAbsent((WearableSlot)slot.get(), (SetSlotBuilder)Util.m_137469_((Object)new SetSlotBuilder(new ResourceLocation(BonusProvider.this.modId, "set/" + this.name + "/wearable/" + location.m_135827_() + "/" + location.m_135815_())), builder));
            return this;
        }

        public SetBuilder slot(WearableSlot slot, Item item) {
            return this.slot(slot, (SetSlotBuilder setSlotBuilder) -> setSlotBuilder.add(item));
        }

        public SetBuilder slot(WearableSlot slot, Supplier<? extends Item> supplier) {
            return this.slot(slot, supplier.get());
        }

        @Override
        public SetBuilder setHidden() {
            return (SetBuilder)super.setHidden();
        }

        @Override
        public SetBuilder setBonus(Bonus<?> bonus) {
            return (SetBuilder)super.setBonus(bonus);
        }

        private Map<EquipmentSlot, SetSlotBuilder> getEquipmentContent() {
            return this.equipmentContent;
        }
    }

    protected static class ItemBuilder {
        private Bonus<?> bonus;
        private boolean hidden;

        protected ItemBuilder() {
        }

        public ItemBuilder setHidden() {
            this.hidden = true;
            return this;
        }

        public ItemBuilder setBonus(Bonus<?> bonus) {
            this.bonus = bonus;
            return this;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        protected Bonus<?> getBonus() {
            return Objects.requireNonNull(this.bonus, "found builder without bonus!");
        }
    }

    protected static class SetSlotBuilder {
        private final TagKey<Item> key;
        private final TagBuilder builder;

        protected SetSlotBuilder(ResourceLocation location) {
            this.key = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)location);
            this.builder = new TagBuilder();
        }

        public SetSlotBuilder add(Item item) {
            this.builder.m_215902_(TagEntry.m_215925_((ResourceLocation)item.m_204114_().m_205785_().m_135782_()));
            return this;
        }

        public SetSlotBuilder addAll(Item ... items) {
            for (Item item : items) {
                this.add(item);
            }
            return this;
        }

        @NotNull
        public SetSlotBuilder addTag(@NotNull TagKey<Item> tagKey) {
            this.builder.m_215907_(tagKey.f_203868_());
            return this;
        }
    }
}

