/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.crafting.serializers.UpgradeItemRecipe;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class UpgradeRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final UpgradeItemRecipe.CraftType type;
    private final Item result;
    private final int count;
    private Ingredient source;
    private Ingredient material;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    public UpgradeRecipeBuilder(RecipeCategory pCategory, UpgradeItemRecipe.CraftType type, ItemLike pResult, int pCount) {
        this.category = pCategory;
        this.type = type;
        this.result = pResult.m_5456_();
        this.count = pCount;
    }

    public static UpgradeRecipeBuilder create(RecipeCategory pCategory, UpgradeItemRecipe.CraftType type, ItemLike pResult) {
        return UpgradeRecipeBuilder.create(pCategory, type, pResult, 1);
    }

    public static UpgradeRecipeBuilder create(RecipeCategory pCategory, UpgradeItemRecipe.CraftType type, ItemLike pResult, int pCount) {
        return new UpgradeRecipeBuilder(pCategory, type, pResult, pCount);
    }

    public UpgradeRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public UpgradeRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public UpgradeRecipeBuilder source(Ingredient ingredient) {
        this.source = ingredient;
        return this;
    }

    public UpgradeRecipeBuilder source(RegistryObject<? extends Item> registryObject) {
        this.source(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
        return this;
    }

    public UpgradeRecipeBuilder source(Item item) {
        this.source(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public UpgradeRecipeBuilder material(Ingredient ingredient) {
        this.material = ingredient;
        return this;
    }

    public UpgradeRecipeBuilder material(RegistryObject<? extends Item> registryObject) {
        this.material(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
        return this;
    }

    public UpgradeRecipeBuilder material(Item item) {
        this.material(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept((FinishedRecipe)new Result(pRecipeId, this.result, this.count, this.group == null ? "" : this.group, UpgradeRecipeBuilder.m_245179_((RecipeCategory)this.category), this.type, this.source, this.material, this.advancement, pRecipeId.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.material == null) {
            throw new IllegalStateException("material not defined in Upgrade recipe " + pId + "!");
        }
        if (this.source == null) {
            throw new IllegalStateException("source not defined in Upgrade recipe " + pId + "!");
        }
    }

    private static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final UpgradeItemRecipe.CraftType type;
        private final Item result;
        private final int count;
        private final String group;
        private final Ingredient source;
        private final Ingredient material;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        private Result(ResourceLocation pId, Item pResult, int pCount, String pGroup, CraftingBookCategory pCategory, UpgradeItemRecipe.CraftType type, Ingredient source, Ingredient material, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId) {
            super(pCategory);
            this.id = pId;
            this.result = pResult;
            this.count = pCount;
            this.group = pGroup;
            this.type = type;
            this.source = source;
            this.material = material;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
        }

        public void m_7917_(JsonObject pJson) {
            super.m_7917_(pJson);
            pJson.addProperty("craft_type", this.type.m_7912_());
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("source", this.source.m_43942_());
            pJson.add("material", this.material.m_43942_());
            JsonObject object = new JsonObject();
            object.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                object.addProperty("count", (Number)this.count);
            }
            pJson.add("result", (JsonElement)object);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ExtraRecipeSerializers.UPGRADE_ITEM.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

