/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.abstracts;

import java.util.HashMap;
import java.util.Map;
import net.kapitencraft.kap_lib.enchantments.abstracts.ModEnchantment;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public interface ExtendedCalculationEnchantment
extends ModEnchantment {
    @NotNull
    public CalculationType type();

    @NotNull
    public ProcessPriority priority();

    public static Map<ExtendedCalculationEnchantment, Integer> getAllEnchantments(ItemStack stack) {
        HashMap<ExtendedCalculationEnchantment, Integer> map = new HashMap<ExtendedCalculationEnchantment, Integer>();
        for (Enchantment enchantment : stack.getAllEnchantments().keySet()) {
            if (!(enchantment instanceof ExtendedCalculationEnchantment)) continue;
            ExtendedCalculationEnchantment extended = (ExtendedCalculationEnchantment)enchantment;
            map.put(extended, (Integer)stack.getAllEnchantments().get(extended));
        }
        return map;
    }

    public static float runWithPriority(ItemStack enchanted, LivingEntity attacker, LivingEntity attacked, float damage, MiscHelper.DamageType type, DamageSource source) {
        Map<ExtendedCalculationEnchantment, Integer> enchantmentIntegerMap = ExtendedCalculationEnchantment.getAllEnchantments(enchanted);
        for (ProcessPriority priority : ProcessPriority.values()) {
            for (ExtendedCalculationEnchantment enchantment : enchantmentIntegerMap.keySet()) {
                if (enchantment.priority() != priority || !RequirementManager.instance.meetsRequirements(RequirementType.ENCHANTMENT, (Enchantment)enchantment, attacker)) continue;
                damage = enchantment.tryExecute(enchantmentIntegerMap.get(enchantment), enchanted, attacker, attacked, damage, type, source);
            }
        }
        return damage;
    }

    default public float tryExecute(int level, ItemStack enchanted, LivingEntity attacker, LivingEntity attacked, float damage, MiscHelper.DamageType type, DamageSource source) {
        if (this.type().contains(type)) {
            float attackStrengthScale = 1.0f;
            if (attacker instanceof Player) {
                Player p = (Player)attacker;
                attackStrengthScale = p.m_36403_(0.0f);
            }
            return this.execute(level, enchanted, attacker, attacked, damage, source, attackStrengthScale);
        }
        return damage;
    }

    public float execute(int var1, ItemStack var2, LivingEntity var3, LivingEntity var4, float var5, DamageSource var6, float var7);

    public static enum ProcessPriority {
        HIGHEST,
        HIGH,
        MEDIUM,
        LOW,
        LOWEST;

    }

    public static enum CalculationType {
        ONLY_MAGIC(MiscHelper.DamageType.MAGIC),
        NOT_MAGIC(MiscHelper.DamageType.MELEE, MiscHelper.DamageType.RANGED),
        ONLY_MELEE(MiscHelper.DamageType.MELEE),
        ONLY_RANGED(MiscHelper.DamageType.RANGED),
        ALL(MiscHelper.DamageType.MAGIC, MiscHelper.DamageType.RANGED, MiscHelper.DamageType.MELEE),
        ALL_RANGED(MiscHelper.DamageType.RANGED, MiscHelper.DamageType.MAGIC);

        private final MiscHelper.DamageType[] types;

        private CalculationType(MiscHelper.DamageType ... types) {
            this.types = types;
        }

        public boolean contains(MiscHelper.DamageType type) {
            for (MiscHelper.DamageType type1 : this.types) {
                if (type1 != type) continue;
                return true;
            }
            return false;
        }
    }
}

