/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CollectionHelper {
    @Nullable
    public static <T, K> T getFirstKey(Map<T, K> collection) {
        return collection.keySet().stream().findFirst().orElse(null);
    }

    public static <T, K> T getKeyForValue(Map<T, K> map, K value) {
        for (Map.Entry<T, K> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T, K> Map<K, T> mirror(Map<T, K> in) {
        HashMap returnMap = new HashMap();
        in.forEach((t, k) -> returnMap.put(k, t));
        return returnMap;
    }

    public static <T, K> Multimap<T, K> sortMap(Multimap<T, K> map, @Nullable Comparator<T> keySorter, @Nullable Comparator<K> valueSorter) {
        List<Object> sortedKeys = CollectionHelper.fromAny(map.keySet());
        MiscHelper.ifNonNull(keySorter, sortedKeys::sort);
        HashMultimap multimap = HashMultimap.create();
        sortedKeys.forEach(arg_0 -> CollectionHelper.lambda$sortMap$1(map, valueSorter, (Multimap)multimap, arg_0));
        return multimap;
    }

    public static <T> int index(T[] src, T obj) {
        for (int i = 0; i < src.length; ++i) {
            if (!src[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public static <T> List<T> mutableList(Collection<T> immutable) {
        return new ArrayList<T>(immutable);
    }

    public static <T> List<T> fromAny(Collection<T> collection) {
        return collection.stream().toList();
    }

    public static <T> void removeMapping2(List<T> ts, BiPredicate<T, T> predicate) {
        ts.removeIf(t -> {
            int id = ts.indexOf(t);
            Object second = id < ts.size() - 1 ? ts.get(id + 1) : ts.get(0);
            return predicate.test(t, second);
        });
    }

    public static <T> void forEachMapping2(List<T> ts, BiConsumer<T, T> consumer) {
        ts.forEach(t -> {
            int id = ts.indexOf(t);
            Object second = id < ts.size() - 1 ? ts.get(id + 1) : ts.get(0);
            consumer.accept(t, second);
        });
    }

    public static <T> List<T> create(int size, Supplier<T> sup) {
        ArrayList list = new ArrayList();
        MiscHelper.repeat(size, integer -> list.add(sup.get()));
        return list;
    }

    public static <T, K> Multimap<T, K> fromMap(Map<T, K> map) {
        HashMultimap multimap = HashMultimap.create();
        for (T t : map.keySet()) {
            multimap.put(t, map.get(t));
        }
        return multimap;
    }

    public static <T> ArrayList<T> toList(T ts) {
        ArrayList target = new ArrayList();
        Collections.addAll(target, ts);
        return target;
    }

    public static <T, K, L, J extends Map<K, L>> List<L> values(Map<T, J> map) {
        return map.values().stream().map(Map::values).flatMap(Collection::stream).toList();
    }

    public static <T, K> K getFirstValue(Map<T, K> map) {
        Iterator<Map.Entry<T, K>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<T, K> entry = iterator.next();
            return entry.getValue();
        }
        return null;
    }

    public static <K, V> void removeIf(Map<K, V> map, Predicate<K> predicate) {
        for (K k : map.keySet()) {
            if (!predicate.test(k)) continue;
            map.remove(k);
        }
    }

    public static <T, V> void forEach(Map<T, Map<T, V>> map, BiConsumer<? super T, ? super V> consumer) {
        for (Map<T, ? super V> map2 : map.values()) {
            map2.forEach(consumer);
        }
    }

    public static <V> ArrayList<V> invertList(ArrayList<V> list) {
        ArrayList<V> out = new ArrayList<V>();
        for (int i = list.size(); i > 0; --i) {
            out.add(list.get(i - 1));
        }
        return out;
    }

    @Contract(value="null, _ -> fail; _, null -> fail")
    public static List<LivingEntity> sortLowestDistance(Entity source, List<LivingEntity> list) {
        if (list.isEmpty()) {
            return List.of();
        }
        return list.stream().sorted(Comparator.comparingDouble(living -> living.m_20238_(source.m_20182_()))).collect(Collectors.toList());
    }

    public static <T> boolean arrayContains(T[] array, T t) {
        return List.of(array).contains(t);
    }

    public static <S, T extends S> Stream<T> cast(Stream<S> in, Class<T> clazz) {
        return in.filter(clazz::isInstance).map(clazz::cast);
    }

    public static String getLast(@NotNull String[] split) {
        if (split.length == 0) {
            throw new IndexOutOfBoundsException("can not get last index from empty array");
        }
        return split[split.length - 1];
    }

    public static <K, V> Multimap<K, V> fromListMap(Map<K, List<V>> map) {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        for (Map.Entry<K, List<V>> kListEntry : map.entrySet()) {
            builder.putAll(kListEntry.getKey(), (Iterable)kListEntry.getValue());
        }
        return builder.build();
    }

    public static <K, V> Map<K, List<V>> fromMultimap(Multimap<K, V> multimap) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Object k : multimap.keySet()) {
            builder.put(k, (Object)ImmutableList.copyOf((Collection)multimap.get(k)));
        }
        return builder.build();
    }

    private static /* synthetic */ void lambda$sortMap$1(Multimap map, Comparator valueSorter, Multimap multimap, Object t) {
        List values = CollectionHelper.mutableList(CollectionHelper.fromAny(map.get(t)));
        MiscHelper.ifNonNull(valueSorter, values::sort);
        multimap.putAll(t, values);
    }
}

