/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.font.effect.EffectsStyle;
import net.kapitencraft.kap_lib.client.font.effect.GlyphEffect;
import net.kapitencraft.kap_lib.client.particle.DamageIndicatorParticleOptions;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.ParticleHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.io.network.ModMessages;
import net.kapitencraft.kap_lib.io.network.S2C.ActivateShakePacket;
import net.kapitencraft.kap_lib.tags.ExtraTags;
import net.kapitencraft.kap_lib.util.Color;
import net.kapitencraft.kap_lib.util.ExtraRarities;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MiscHelper {
    public static final String OVERFLOW_MANA_ID = "overflowMana";
    public static final char HEART = '\u2661';
    public static final EquipmentSlot[] ARMOR_EQUIPMENT = (EquipmentSlot[])Arrays.stream(EquipmentSlot.values()).filter(EquipmentSlot::m_254934_).toArray(EquipmentSlot[]::new);
    public static final EquipmentSlot[] WEAPON_SLOT = new EquipmentSlot[]{EquipmentSlot.MAINHAND};

    public static EquipmentSlot getSlotForStack(@NotNull ItemStack stack) {
        return LivingEntity.m_147233_((ItemStack)stack);
    }

    @Contract(value="null, _ -> param2; !null, _ -> param1")
    public static <T> T nonNullOr(@Nullable T value, @NotNull T or) {
        return value == null ? or : value;
    }

    public static void sendManaBoostParticles(Entity target, RandomSource random, Vec3 delta) {
        ClientHelper.sendElytraBoostParticles(target, random, delta, new Color(0.0f, 0.0f, 1.0f, 1.0f), new Color(0.5f, 0.0f, 0.5f, 1.0f));
    }

    public static void swapHands(@NotNull LivingEntity living) {
        ItemStack mainHand = living.m_21205_();
        living.m_21008_(InteractionHand.MAIN_HAND, living.m_21206_());
        living.m_21008_(InteractionHand.OFF_HAND, mainHand);
    }

    public static Style withSpecial(Style style, Supplier<? extends GlyphEffect> effect) {
        return MiscHelper.withSpecial(style, effect.get());
    }

    public static Style withSpecial(Style style, GlyphEffect effect) {
        return EffectsStyle.of(style).addEffect(effect);
    }

    public static int repairPlayerItems(@NotNull Player player, int value, @NotNull Enchantment ench) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)ench, (LivingEntity)player, ItemStack::m_41768_);
        if (entry != null) {
            ItemStack itemstack = (ItemStack)entry.getValue();
            int i = Math.min((int)((float)value * itemstack.getXpRepairRatio()), itemstack.m_41773_());
            itemstack.m_41721_(itemstack.m_41773_() - i);
            int j = value - i / 2;
            return j > 0 ? MiscHelper.repairPlayerItems(player, j, ench) : 0;
        }
        return value;
    }

    public static boolean is(Item item, TagKey<Item> tagKey) {
        return item.m_204114_().m_203656_(tagKey);
    }

    public static void getEnchantmentLevelAndDo(ItemStack stack, Enchantment enchantment, Consumer<Integer> enchConsumer) {
        if (stack.getEnchantmentLevel(enchantment) > 0) {
            enchConsumer.accept(stack.getEnchantmentLevel(enchantment));
        }
    }

    @Contract(value="null, _ -> fail; _, null -> fail")
    public static Rarity getFinalRarity(Rarity rarity, ItemStack stack) {
        if (!stack.m_41793_()) {
            return rarity;
        }
        return switch (rarity) {
            case Rarity.COMMON -> Rarity.UNCOMMON;
            case Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            case Rarity.EPIC -> ExtraRarities.LEGENDARY;
            default -> rarity == ExtraRarities.LEGENDARY ? ExtraRarities.MYTHIC : (rarity == ExtraRarities.MYTHIC ? ExtraRarities.DIVINE : Rarity.COMMON);
        };
    }

    public static <T> T forDifficulty(Difficulty difficulty, T easy, T medium, T hard, T peaceful) {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.EASY -> easy;
            case Difficulty.NORMAL -> medium;
            case Difficulty.HARD -> hard;
            case Difficulty.PEACEFUL -> peaceful;
        };
    }

    public static <T> void ifNonNull(@Nullable T t, Consumer<T> toDo) {
        if (t != null) {
            toDo.accept(t);
        }
    }

    @NotNull
    public static <T, K> K ifNonNullOrDefault(@Nullable T t, Function<T, K> function, Supplier<K> defaulted) {
        if (t != null) {
            return function.apply(t);
        }
        return defaulted.get();
    }

    @Contract(value="_ -> new")
    public static Item.Properties rarity(Rarity rarity) {
        return new Item.Properties().m_41497_(rarity);
    }

    @Deprecated(forRemoval=true)
    public static boolean awardAchievement(ServerPlayer player, ResourceLocation achievementName) {
        AdvancementProgress progress;
        ServerAdvancementManager manager = player.f_8924_.m_129889_();
        Advancement adv = manager.m_136041_(achievementName);
        PlayerAdvancements advancements = player.m_8960_();
        if (adv != null && !(progress = advancements.m_135996_(adv)).m_8193_()) {
            for (String s : progress.m_8219_()) {
                advancements.m_135988_(adv, s);
            }
            return true;
        }
        return false;
    }

    public static <T, K> T getValue(Function<T, K> provider, T defaultValue, K key, T ... values) {
        for (T t : values) {
            if (!provider.apply(t).equals(key)) continue;
            return t;
        }
        return defaultValue;
    }

    public static void schedule(int delayTicks, final Runnable run) {
        new Object(){
            private int ticks = 0;
            private float waitTicks;

            public void start(int waitTicks) {
                this.waitTicks = waitTicks;
                MinecraftForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void tick(TickEvent.ServerTickEvent event) {
                if (event.phase == TickEvent.Phase.END) {
                    ++this.ticks;
                    if ((float)this.ticks >= this.waitTicks) {
                        this.end();
                    }
                }
            }

            private void end() {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                run.run();
            }
        }.start(delayTicks);
    }

    public static boolean saveTeleport(Entity entity, double maxRange) {
        try {
            Vec3 targetPos = entity.m_20154_().m_82490_(maxRange);
            entity.m_8127_();
            entity.m_6478_(MoverType.SELF, targetPos);
        }
        catch (Exception e) {
            KapLibMod.LOGGER.warn("error trying to teleport entity '{}': {}", (Object)entity, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static void teleport(Entity entity, Vec3 teleportPosition) {
        entity.m_6021_(teleportPosition.f_82479_, teleportPosition.f_82480_, teleportPosition.f_82481_);
        entity.f_19789_ = 0.0f;
        entity.m_9236_().m_245803_(entity, BlockPos.m_274446_((Position)entity.m_20182_()), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void repeat(int times, Consumer<Integer> consumer) {
        for (int i = 0; i < times; ++i) {
            consumer.accept(i);
        }
    }

    public static MutableComponent buildComponent(MutableComponent ... components) {
        MutableComponent empty = Component.m_237119_();
        for (MutableComponent component : components) {
            empty.m_7220_((Component)component);
        }
        return empty;
    }

    @Nullable
    public static LivingEntity getAttacker(@NotNull DamageSource source) {
        LivingEntity living;
        Entity entity = source.m_7639_();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    @Contract(value="null -> fail", pure=true)
    public static DamageType getDamageType(DamageSource source) {
        if (source.m_269533_(ExtraTags.DamageTypes.MAGIC)) {
            return DamageType.MAGIC;
        }
        if (source.m_7639_() != null) {
            if (source.m_7640_() == source.m_7639_()) {
                return DamageType.MELEE;
            }
            return DamageType.RANGED;
        }
        return DamageType.MISC;
    }

    public static ArmorStand createMarker(Vec3 pos, Level level, boolean invisible) {
        ArmorStand stand = new ArmorStand(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        CompoundTag tag = stand.getPersistentData();
        tag.m_128379_("Marker", true);
        stand.m_20331_(true);
        stand.m_6842_(invisible);
        stand.m_20242_(true);
        stand.m_20011_(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        return stand;
    }

    public static <T> T of(Supplier<T> sup) {
        return sup.get();
    }

    public static void createDamageIndicator(LivingEntity entity, float amount, String type) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float rangeOffset = entity.m_20206_() / 2.0f;
            ParticleHelper.sendParticles((Level)serverLevel, new DamageIndicatorParticleOptions(TextHelper.damageIndicatorCoder(type), amount, rangeOffset), false, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    private static Vec3 getUpdateForPos(Vec3 cam, LivingEntity living) {
        Vec3 livingPos = living.m_20182_();
        Vec3 delta = cam.m_82546_(livingPos);
        return MathHelper.clampLength(delta, 0.5);
    }

    public static ArmorStand createHealthIndicator(LivingEntity target) {
        ArmorStand marker = MiscHelper.createMarker(target.m_20182_().m_82520_(0.0, 0.5, 0.0), target.m_9236_(), true);
        CompoundTag tag = marker.getPersistentData();
        tag.m_128379_("healthMarker", true);
        marker.m_6593_((Component)Component.m_237113_((String)("\u2661 " + target.m_21223_() + "/" + target.m_21233_())));
        marker.m_20340_(true);
        target.m_9236_().m_7967_((Entity)marker);
        return marker;
    }

    public static Rarity getItemRarity(Item item) {
        return item.m_41460_(new ItemStack((ItemLike)item));
    }

    public static Stream<ItemStack> getArmorEquipment(LivingEntity living) {
        return Arrays.stream(ARMOR_EQUIPMENT).map(arg_0 -> ((LivingEntity)living).m_6844_(arg_0));
    }

    public static boolean increaseEffectDuration(LivingEntity living, MobEffect effect, int ticks) {
        if (living.m_21023_(effect)) {
            MobEffectInstance oldInstance = living.m_21124_(effect);
            assert (oldInstance != null);
            oldInstance.f_19503_ += ticks;
            return true;
        }
        return false;
    }

    public static void maxEffectDuration(LivingEntity living, MobEffect effect, int minTicks) {
        if (living.m_21023_(effect)) {
            MobEffectInstance oldInstance = living.m_21124_(effect);
            assert (oldInstance != null);
            oldInstance.f_19503_ = Math.max(oldInstance.f_19503_, minTicks);
        } else {
            living.m_7292_(new MobEffectInstance(effect, minTicks));
        }
    }

    public static char[] append(char[] in, char toAppend) {
        char[] copy = new char[in.length + 1];
        MiscHelper.repeat(in.length, integer -> {
            copy[integer.intValue()] = in[integer];
        });
        copy[in.length] = toAppend;
        return copy;
    }

    @Contract(value="_, _, _ -> param1")
    public static List<ItemStack> shrinkDrops(@NotNull List<ItemStack> drops, Item item, int amount) {
        MiscHelper.repeat(drops.size(), i -> {
            ItemStack stack = (ItemStack)drops.get((int)i);
            if (stack.m_41720_() == item) {
                for (int varAmount = amount; varAmount > 0; --varAmount) {
                    stack.m_41774_(1);
                    if (!stack.m_41619_()) continue;
                    drops.remove(i);
                    break;
                }
            }
        });
        return drops;
    }

    public static void shakeGround(ServerLevel level, Vec3 pos, float intensity, float strength, float frequency) {
        float radius = strength / intensity;
        List targets = level.m_45976_(ServerPlayer.class, new AABB(pos, pos).m_82400_((double)radius));
        targets.forEach(p -> {
            float dist = Mth.m_14116_((float)((float)p.m_20238_(pos)));
            ModMessages.sendToClientPlayer(new ActivateShakePacket(intensity, strength * (dist / radius), frequency), p);
        });
    }

    public static Item[] getItemsFromTag(RegistryAccess access, TagKey<Item> tag) {
        return (Item[])((HolderSet.Named)access.m_175515_(ForgeRegistries.Keys.ITEMS).m_203431_(tag).orElseThrow(NullPointerException::new)).m_203661_().stream().map(Holder::m_203334_).toArray(Item[]::new);
    }

    public static Holder<net.minecraft.world.damagesource.DamageType> lookupDamageTypeHolder(Level level, ResourceKey<net.minecraft.world.damagesource.DamageType> key) {
        return level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(key);
    }

    public static enum DamageType {
        RANGED,
        MELEE,
        MAGIC,
        MISC;

    }
}

