/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.network.S2C;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.io.network.SimplePacket;
import net.kapitencraft.kap_lib.item.bonus.BonusManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class UpdateBonusDataPacket
implements SimplePacket {
    private final ItemStack from;
    private final ItemStack to;
    private final EquipmentSlot slot;
    private final int entityId;

    public UpdateBonusDataPacket(ItemStack from, ItemStack stack, EquipmentSlot slot, int entityId) {
        this.from = from;
        this.to = stack;
        this.slot = slot;
        this.entityId = entityId;
    }

    public UpdateBonusDataPacket(FriendlyByteBuf buf) {
        this(buf.m_130267_(), buf.m_130267_(), (EquipmentSlot)buf.m_130066_(EquipmentSlot.class), buf.readInt());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.from);
        buf.m_130055_(this.to);
        buf.m_130068_((Enum)this.slot);
        buf.writeInt(this.entityId);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> sup) {
        sup.get().enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                BonusManager.swapFrom(living, this.slot, this.to, this.from);
            }
        });
    }
}

