/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnDeserializers;
import net.kapitencraft.kap_lib.spawn_table.SpawnPool;
import net.kapitencraft.kap_lib.spawn_table.SpawnTableProvider;
import net.kapitencraft.kap_lib.spawn_table.functions.core.FunctionUserBuilder;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SpawnTable {
    public static final Gson PARSER = SpawnDeserializers.createSpawnTableSerializer().create();
    public static final TriFunction<ResourceLocation, JsonElement, ResourceManager, Optional<SpawnTable>> CREATOR = SpawnTableProvider.getSpawnTableSerializer(PARSER, "spawn_tables");
    static final Logger LOGGER = LogUtils.getLogger();
    public static final SpawnTable EMPTY = new SpawnTable(LootContextParamSets.f_81410_, null, new SpawnPool[0], new SpawnEntityFunction[0]);
    public static final LootContextParamSet DEFAULT_PARAM_SET = LootContextParamSets.f_81420_;
    final LootContextParamSet paramSet;
    @javax.annotation.Nullable
    final ResourceLocation randomSequence;
    private final List<SpawnPool> pools;
    final SpawnEntityFunction[] functions;
    private final BiFunction<Entity, SpawnContext, Entity> compositeFunction;
    private boolean isFrozen = false;
    private ResourceLocation lootTableId;

    private static LootDataType.Validator<SpawnTable> createValidator() {
        return (context, dataId, table) -> table.validate(context.m_79355_(table.getParamSet()).m_278632_("{" + dataId.f_278383_().m_278624_() + ":" + dataId.f_278500_() + "}", dataId));
    }

    SpawnTable(LootContextParamSet pParamSet, @javax.annotation.Nullable ResourceLocation pRandomSequence, SpawnPool[] pPools, SpawnEntityFunction[] pFunctions) {
        this.paramSet = pParamSet;
        this.randomSequence = pRandomSequence;
        this.pools = Lists.newArrayList((Object[])pPools);
        this.functions = pFunctions;
        this.compositeFunction = SpawnEntityFunctions.compose(pFunctions);
    }

    public void getRandomEntities(LootParams pParams, long pSeed, Consumer<Entity> pOutput) {
        this.getRandomEntities(new SpawnContext.Builder(pParams).withOptionalRandomSeed(pSeed).create(this.randomSequence)).forEach(pOutput);
    }

    public void getRandomEntities(LootParams pParams, Consumer<Entity> pOutput) {
        this.getRandomEntities(pParams).forEach(pOutput);
    }

    public void getRandomEntities(SpawnContext pContextData, Consumer<Entity> pOutput) {
        this.getRandomEntities(pContextData).forEach(entity -> {
            pContextData.m_78952_().m_7967_(entity);
            pOutput.accept((Entity)entity);
        });
    }

    public ObjectArrayList<Entity> getRandomEntities(LootParams pParams, long pSeed) {
        return this.getRandomEntities(new SpawnContext.Builder(pParams).withOptionalRandomSeed(pSeed).create(this.randomSequence));
    }

    public ObjectArrayList<Entity> getRandomEntities(LootParams pParams) {
        return this.getRandomEntities(new SpawnContext.Builder(pParams).create(this.randomSequence));
    }

    private ObjectArrayList<Entity> getRandomEntities(SpawnContext pContext) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Consumer<Entity> consumer = SpawnEntityFunction.decorate(this.compositeFunction, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0), pContext);
        for (SpawnPool pool : this.pools) {
            pool.addRandomEntities(consumer, pContext);
        }
        return objectarraylist;
    }

    public LootContextParamSet getParamSet() {
        return this.paramSet;
    }

    public void validate(ValidationContext pValidator) {
        for (int i = 0; i < this.pools.size(); ++i) {
            this.pools.get(i).validate(pValidator.m_79365_(".pools[" + i + "]"));
        }
        for (int j = 0; j < this.functions.length; ++j) {
            this.functions[j].m_6169_(pValidator.m_79365_(".functions[" + j + "]"));
        }
    }

    public static Builder spawnTable() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
        this.pools.forEach(SpawnPool::freeze);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public void setId(ResourceLocation id) {
        if (this.lootTableId != null) {
            throw new IllegalStateException("Attempted to rename loot table from '" + this.lootTableId + "' to '" + id + "': this is not supported");
        }
        this.lootTableId = Objects.requireNonNull(id);
    }

    public ResourceLocation getLootTableId() {
        return this.lootTableId;
    }

    @Nullable
    public SpawnPool getPool(String name) {
        return this.pools.stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    @Nullable
    public SpawnPool removePool(String name) {
        this.checkFrozen();
        for (SpawnPool pool : this.pools) {
            if (!name.equals(pool.getName())) continue;
            this.pools.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(SpawnPool pool) {
        this.checkFrozen();
        if (this.pools.stream().anyMatch(e -> e == pool || e.getName() != null && e.getName().equals(pool.getName()))) {
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + pool.getName());
        }
        this.pools.add(pool);
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final List<SpawnPool> pools = Lists.newArrayList();
        private final List<SpawnEntityFunction> functions = Lists.newArrayList();
        private LootContextParamSet paramSet = DEFAULT_PARAM_SET;
        @javax.annotation.Nullable
        private ResourceLocation randomSequence = null;

        public Builder withPool(SpawnPool.Builder pLootPool) {
            this.pools.add(pLootPool.build());
            return this;
        }

        public Builder setParamSet(LootContextParamSet pParameterSet) {
            this.paramSet = pParameterSet;
            return this;
        }

        public Builder setRandomSequence(ResourceLocation pRandomSequence) {
            this.randomSequence = pRandomSequence;
            return this;
        }

        @Override
        public Builder apply(SpawnEntityFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder.build());
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public SpawnTable build() {
            return new SpawnTable(this.paramSet, this.randomSequence, this.pools.toArray(new SpawnPool[0]), this.functions.toArray(new SpawnEntityFunction[0]));
        }
    }

    public static class Serializer
    implements JsonDeserializer<SpawnTable>,
    JsonSerializer<SpawnTable> {
        public SpawnTable deserialize(JsonElement pJson, Type pTypeOfT, JsonDeserializationContext pContext) throws JsonParseException {
            ResourceLocation resourcelocation;
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"loot table");
            SpawnPool[] alootpool = (SpawnPool[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"pools", (Object)new SpawnPool[0], (JsonDeserializationContext)pContext, SpawnPool[].class);
            LootContextParamSet lootcontextparamset = null;
            if (jsonobject.has("type")) {
                String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type");
                lootcontextparamset = LootContextParamSets.m_81431_((ResourceLocation)new ResourceLocation(s));
            }
            if (jsonobject.has("random_sequence")) {
                String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"random_sequence");
                resourcelocation = new ResourceLocation(s1);
            } else {
                resourcelocation = null;
            }
            SpawnEntityFunction[] alootitemfunction = (SpawnEntityFunction[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"functions", (Object)new SpawnEntityFunction[0], (JsonDeserializationContext)pContext, SpawnEntityFunction[].class);
            return new SpawnTable(lootcontextparamset != null ? lootcontextparamset : LootContextParamSets.f_81420_, resourcelocation, alootpool, alootitemfunction);
        }

        public JsonElement serialize(SpawnTable pSrc, Type pTypeOfSrc, JsonSerializationContext pContext) {
            JsonObject jsonobject = new JsonObject();
            if (pSrc.paramSet != DEFAULT_PARAM_SET) {
                ResourceLocation resourcelocation = LootContextParamSets.m_81426_((LootContextParamSet)pSrc.paramSet);
                if (resourcelocation != null) {
                    jsonobject.addProperty("type", resourcelocation.toString());
                } else {
                    LOGGER.warn("Failed to find id for param set {}", (Object)pSrc.paramSet);
                }
            }
            if (pSrc.randomSequence != null) {
                jsonobject.addProperty("random_sequence", pSrc.randomSequence.toString());
            }
            if (!pSrc.pools.isEmpty()) {
                jsonobject.add("pools", pContext.serialize(pSrc.pools));
            }
            if (!ArrayUtils.isEmpty((Object[])pSrc.functions)) {
                jsonobject.add("functions", pContext.serialize((Object)pSrc.functions));
            }
            return jsonobject;
        }
    }
}

