/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.entries.ComposableEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.CompositeEntryBase;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.ArrayUtils;

public class AlternativesEntry
extends CompositeEntryBase {
    public AlternativesEntry(SpawnPoolEntryContainer[] pChildren, LootItemCondition[] pConditions) {
        super(pChildren, pConditions);
    }

    @Override
    public SpawnPoolEntryType getType() {
        return (SpawnPoolEntryType)((Object)SpawnPoolEntries.ALTERNATIVES.get());
    }

    @Override
    protected ComposableEntryContainer compose(ComposableEntryContainer[] pEntries) {
        return switch (pEntries.length) {
            case 0 -> ComposableEntryContainer.ALWAYS_FALSE;
            case 1 -> pEntries[0];
            case 2 -> pEntries[0].or(pEntries[1]);
            default -> (p_79393_, p_79394_) -> {
                for (ComposableEntryContainer composableentrycontainer : pEntries) {
                    if (!composableentrycontainer.expand(p_79393_, p_79394_)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        for (int i = 0; i < this.children.length - 1; ++i) {
            if (!ArrayUtils.isEmpty((Object[])this.children[i].conditions)) continue;
            pValidationContext.m_79357_("Unreachable entry!");
        }
    }

    public static Builder alternatives(SpawnPoolEntryContainer.Builder<?> ... pChildren) {
        return new Builder(pChildren);
    }

    public static <E> Builder alternatives(Collection<E> pChildrenSources, Function<E, SpawnPoolEntryContainer.Builder<?>> pToChildrenFunction) {
        return new Builder((SpawnPoolEntryContainer.Builder[])pChildrenSources.stream().map(pToChildrenFunction::apply).toArray(SpawnPoolEntryContainer.Builder[]::new));
    }

    public static class Builder
    extends SpawnPoolEntryContainer.Builder<Builder> {
        private final List<SpawnPoolEntryContainer> entries = Lists.newArrayList();

        public Builder(SpawnPoolEntryContainer.Builder<?> ... pChildren) {
            for (SpawnPoolEntryContainer.Builder<?> builder : pChildren) {
                this.entries.add(builder.build());
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder otherwise(SpawnPoolEntryContainer.Builder<?> pChildBuilder) {
            this.entries.add(pChildBuilder.build());
            return this;
        }

        @Override
        public SpawnPoolEntryContainer build() {
            return new AlternativesEntry(this.entries.toArray(new SpawnPoolEntryContainer[0]), this.getConditions());
        }
    }
}

