/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util.attribute;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="kap_lib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AttributeAdder {
    private static final isAInstance ONLY_WITH_BRAIN = entityType -> entityType.m_20674_() != MobCategory.MISC || entityType == EntityType.f_20532_;
    private static final isAInstance LIVINGS = entityType -> true;

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.STRENGTH.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.CRIT_DAMAGE.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.RANGED_DAMAGE.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.ARROW_COUNT.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.MAGIC_DEFENCE.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.TRUE_DEFENCE.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.BONUS_ATTACK_SPEED.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.CRIT_CHANCE.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.COOLDOWN_REDUCTION.get(), LIVINGS);
        AttributeAdder.addAll(event, (Attribute)ExtraAttributes.VITALITY.get(), ONLY_WITH_BRAIN);
        AttributeAdder.addToPlayer(event, new Supplier[]{ExtraAttributes.MINING_FORTUNE, ExtraAttributes.PRISTINE, ExtraAttributes.MINING_SPEED, ExtraAttributes.MAGIC_DAMAGE, ExtraAttributes.MANA_COST, ExtraAttributes.INTELLIGENCE, ExtraAttributes.FEROCITY, ExtraAttributes.MAX_MANA, ExtraAttributes.MANA_REGEN, ExtraAttributes.MANA, ExtraAttributes.DODGE, ExtraAttributes.LIVE_STEAL, ExtraAttributes.DRAW_SPEED, ExtraAttributes.PROJECTILE_SPEED, ExtraAttributes.ARMOR_SHREDDER, ExtraAttributes.DOUBLE_JUMP, ExtraAttributes.FISHING_SPEED, ExtraAttributes.WISDOM});
    }

    @SafeVarargs
    private static void addToPlayer(EntityAttributeModificationEvent event, Supplier<Attribute> ... attributes) {
        Arrays.stream(attributes).map(Supplier::get).forEach(attribute -> event.add(EntityType.f_20532_, attribute));
    }

    private static void addAll(EntityAttributeModificationEvent event, Attribute attribute, isAInstance generator) {
        ForgeRegistries.ENTITY_TYPES.getValues().stream().map(AttributeAdder::toLiving).filter(Objects::nonNull).filter(generator::is).forEach(entityType -> event.add(entityType, attribute));
    }

    private static EntityType<? extends LivingEntity> toLiving(EntityType<?> in) {
        try {
            return in;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static interface isAInstance {
        public boolean is(EntityType<? extends LivingEntity> var1);
    }
}

