/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.text.DecimalFormat;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.config.ServerModConfig;
import net.kapitencraft.kap_lib.crafting.ExtraRecipeTypes;
import net.kapitencraft.kap_lib.helpers.CommandHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ExtraComponentContents;
import net.kapitencraft.kap_lib.registry.ExtraLootItemConditions;
import net.kapitencraft.kap_lib.registry.ExtraLootModifiers;
import net.kapitencraft.kap_lib.registry.ExtraMobEffects;
import net.kapitencraft.kap_lib.registry.ExtraParticleTypes;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.kapitencraft.kap_lib.registry.TestCooldowns;
import net.kapitencraft.kap_lib.registry.TestItems;
import net.kapitencraft.kap_lib.registry.custom.AttributeModifierTypes;
import net.kapitencraft.kap_lib.registry.custom.BonusTypes;
import net.kapitencraft.kap_lib.registry.custom.CameraModifiers;
import net.kapitencraft.kap_lib.registry.custom.GlyphEffects;
import net.kapitencraft.kap_lib.registry.custom.Overlays;
import net.kapitencraft.kap_lib.registry.custom.RequirementTypes;
import net.kapitencraft.kap_lib.registry.custom.WearableSlots;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ActivationTriggers;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ElementTypes;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.FinalizerTypes;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.TerminatorTriggers;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaAttributeModifierTypes;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaComponentContentTypes;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaDataSourceTypes;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaInventoryPages;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.Marker;

@Mod(value="kap_lib")
@ApiStatus.Internal
public class KapLibMod {
    public static final String MOD_ID = "kap_lib";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker MARKER = Markers.getMarker("KapLib");
    private static boolean enableManaOverlay;
    @ApiStatus.Internal
    public static final File ROOT;
    public static final RandomSource RANDOM_SOURCE;

    public static ResourceLocation res(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public KapLibMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExtraComponentContents.REGISTRY.register(modEventBus);
        ExtraAttributes.REGISTRY.register(modEventBus);
        ExtraLootModifiers.REGISTRY.register(modEventBus);
        ExtraLootItemConditions.REGISTRY.register(modEventBus);
        ExtraParticleTypes.REGISTRY.register(modEventBus);
        ExtraRecipeSerializers.REGISTRY.register(modEventBus);
        ExtraRecipeTypes.REGISTRY.register(modEventBus);
        ExtraMobEffects.REGISTRY.register(modEventBus);
        RequirementTypes.REGISTRY.register(modEventBus);
        BonusTypes.REGISTRY.register(modEventBus);
        GlyphEffects.REGISTRY.register(modEventBus);
        WearableSlots.REGISTRY.register(modEventBus);
        ElementTypes.REGISTRY.register(modEventBus);
        SpawnerTypes.REGISTRY.register(modEventBus);
        FinalizerTypes.REGISTRY.register(modEventBus);
        TerminatorTriggers.REGISTRY.register(modEventBus);
        ActivationTriggers.REGISTRY.register(modEventBus);
        CameraModifiers.REGISTRY.register(modEventBus);
        SpawnEntityFunctions.REGISTRY.register(modEventBus);
        SpawnPoolEntries.REGISTRY.register(modEventBus);
        Overlays.REGISTRY.register(modEventBus);
        AttributeModifierTypes.REGISTRY.register(modEventBus);
        VanillaAttributeModifierTypes.REGISTRY.register(modEventBus);
        VanillaComponentContentTypes.REGISTRY.register(modEventBus);
        VanillaDataSourceTypes.REGISTRY.register(modEventBus);
        VanillaInventoryPages.REGISTRY.register(modEventBus);
        if (ForgeGameTestHooks.isGametestEnabled()) {
            TestItems.REGISTRY.register(modEventBus);
            TestCooldowns.REGISTRY.register(modEventBus);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientModConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerModConfig.SPEC);
        MinecraftForge.EVENT_BUS.addListener(CommandHelper::registerClient);
        MinecraftForge.EVENT_BUS.addListener(CommandHelper::registerServer);
        ArtifactVersion modVersion = ModList.get().getModContainerById(MOD_ID).map(ModContainer::getModInfo).map(IModInfo::getVersion).orElse(null);
        if (modVersion == null) {
            throw new IllegalStateException("KapLib version not found");
        }
        StartupMessageManager.addModMessage((String)("KapLib Mod v" + modVersion + " loaded"));
        LOGGER.info(MARKER, "KapLib v{} loaded", (Object)modVersion);
    }

    public static String doubleFormat(double d) {
        return new DecimalFormat("#.##").format(d);
    }

    public static <T> DeferredRegister<T> registry(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)MOD_ID);
    }

    public static <T> DeferredRegister<T> registry(ResourceKey<Registry<T>> key) {
        return DeferredRegister.create(key, (String)MOD_ID);
    }

    public static void enableManaOverlay() {
        enableManaOverlay = true;
    }

    public static boolean isEnableManaOverlay() {
        return enableManaOverlay;
    }

    static {
        ROOT = new File("./kap_lib");
        RANDOM_SOURCE = RandomSource.m_216327_();
    }
}

