/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.cam.core;

import java.util.Arrays;
import net.kapitencraft.kap_lib.client.cam.core.CameraData;
import net.kapitencraft.kap_lib.client.cam.core.TrackingShotData;
import net.kapitencraft.kap_lib.client.cam.modifiers.Modifier;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrackingShot {
    private final TrackingShotData data;
    private Modifier modifier;
    private int tickCount;
    private int rotIndex;
    private int index;
    private int rotStartTick;
    private int posStartTick;

    public TrackingShot(TrackingShotData data) {
        this.data = data;
    }

    public static TrackingShotData.Builder builder() {
        return new TrackingShotData.Builder();
    }

    public void setup() {
        this.modifier = this.data.modifiers[0];
    }

    public void tick(CameraData camData) {
        try {
            int deltaTickTime = this.tickCount - this.posStartTick;
            this.modifier.modify(deltaTickTime, (double)deltaTickTime / (double)(this.data.times[this.posStartTick] - 1), camData);
            if (deltaTickTime >= this.data.times[this.index] && ++this.index < this.data.modifiers.length) {
                this.modifier = this.data.modifiers[this.index];
                this.posStartTick = this.tickCount;
            }
            ++this.tickCount;
        }
        catch (Exception e) {
            CrashReport report = new CrashReport("Ticking TrackingShot", (Throwable)e);
            report.m_127514_("Tracking Shot Data").m_128159_("ModifierData", (Object)Arrays.toString(this.data.modifiers)).m_128159_("ModifierTimes", (Object)Arrays.toString(this.data.times)).m_128159_("Disable Shake", (Object)this.data.suppressShake);
            throw new ReportedException(report);
        }
    }

    boolean suppressesShake() {
        return this.data.suppressesShake();
    }

    public boolean done() {
        return this.index == this.data.modifiers.length;
    }
}

