/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.cam.modifiers;

import net.kapitencraft.kap_lib.client.cam.core.CameraData;
import net.kapitencraft.kap_lib.client.cam.modifiers.Modifier;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.registry.custom.CameraModifiers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class FixedTargetPositionModifier
implements Modifier {
    private final Vec3 pos;

    public FixedTargetPositionModifier(Vec3 pos) {
        this.pos = pos;
    }

    @Override
    public void modify(int ticks, double percentage, CameraData data) {
        data.rot = MathHelper.withRoll(MathHelper.createTargetRotationFromPos(data.pos, this.pos), 0.0f);
    }

    public Type getType() {
        return (Type)CameraModifiers.FIXED_TARGET_POSITION.get();
    }

    public static class Type
    implements Modifier.Type<FixedTargetPositionModifier> {
        @Override
        public FixedTargetPositionModifier fromNetwork(FriendlyByteBuf buf) {
            return new FixedTargetPositionModifier(NetworkHelper.readVec3(buf));
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, FixedTargetPositionModifier value) {
            NetworkHelper.writeVec3(buf, value.pos);
        }
    }
}

