/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.particle.LightningParticleOptions;
import net.kapitencraft.kap_lib.client.particle.SimpleParticleRenderType;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LightningParticle
extends Particle {
    private static final ParticleRenderType RENDER_TYPE = new SimpleParticleRenderType(RenderType.m_110502_());
    private final Vector3f[] vertexes;

    protected LightningParticle(ClientLevel pLevel, Vec3 start, Vec3 end, int segments, int lifetime, float displacement, float width) {
        super(pLevel, 0.0, 0.0, 0.0);
        this.vertexes = this.createVertexes(start, end, segments, displacement, width);
        this.m_107259_(new AABB(start, end));
        this.f_107230_ = 0.3f;
        this.f_107225_ = lifetime;
    }

    private Vector3f[] createVertexes(Vec3 start, Vec3 end, int segments, float displacement, float width) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        points.add(start);
        Vec3 direction = end.m_82546_(start);
        Vec3 dirNorm = direction.m_82541_();
        Vec3 arbitrary = new Vec3(0.0, 1.0, 0.0);
        if (Math.abs(dirNorm.f_82480_) > (double)0.99f) {
            arbitrary = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 u = dirNorm.m_82537_(arbitrary).m_82541_();
        Vec3 v = dirNorm.m_82537_(u).m_82541_();
        RandomSource source = RandomSource.m_216327_();
        for (int i = 1; i < segments; ++i) {
            float t = (float)i / (float)segments;
            Vec3 point = start.m_82549_(direction.m_82490_((double)t));
            float fade = 1.0f - Math.abs(0.5f - t) * 2.0f;
            float offsetU = (source.m_188501_() - 0.5f) * 2.0f * displacement * fade;
            float offsetV = (source.m_188501_() - 0.5f) * 2.0f * displacement * fade;
            points.add(point.m_82549_(u.m_82490_((double)offsetU).m_82549_(v.m_82490_((double)offsetV))));
        }
        points.add(end);
        float sizeScale = width / 0.7f;
        ArrayList<Vec3> vertexes = new ArrayList<Vec3>();
        for (int i = 1; i < points.size(); ++i) {
            Vec3 oldPos = (Vec3)points.get(i - 1);
            Vec3 pos = (Vec3)points.get(i);
            for (int j = 0; j < 4; ++j) {
                float f10 = (0.1f + (float)j * 0.2f) * sizeScale;
                float f11 = (0.1f + (float)j * 0.2f) * sizeScale;
                this.quad(vertexes, pos, oldPos, u, v, f10, f11, false, false, true, false);
                this.quad(vertexes, pos, oldPos, u, v, f10, f11, true, false, true, true);
                this.quad(vertexes, pos, oldPos, u, v, f10, f11, true, true, false, true);
                this.quad(vertexes, pos, oldPos, u, v, f10, f11, false, true, false, false);
            }
        }
        return (Vector3f[])vertexes.stream().map(Vec3::m_252839_).toArray(Vector3f[]::new);
    }

    private void quad(List<Vec3> positions, Vec3 start, Vec3 stop, Vec3 u, Vec3 v, float p_115283_, float p_115284_, boolean p_115285_, boolean p_115286_, boolean p_115287_, boolean p_115288_) {
        positions.add(start.m_82549_(u.m_82490_(p_115285_ ? (double)p_115284_ : (double)(-p_115284_))).m_82549_(v.m_82490_(p_115286_ ? (double)p_115284_ : (double)(-p_115284_))));
        positions.add(stop.m_82549_(u.m_82490_(p_115285_ ? (double)p_115283_ : (double)(-p_115283_))).m_82549_(v.m_82490_(p_115286_ ? (double)p_115283_ : (double)(-p_115283_))));
        positions.add(stop.m_82549_(u.m_82490_(p_115287_ ? (double)p_115283_ : (double)(-p_115283_))).m_82549_(v.m_82490_(p_115288_ ? (double)p_115283_ : (double)(-p_115283_))));
        positions.add(start.m_82549_(u.m_82490_(p_115287_ ? (double)p_115284_ : (double)(-p_115284_))).m_82549_(v.m_82490_(p_115288_ ? (double)p_115284_ : (double)(-p_115284_))));
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        Vec3 camPos = pRenderInfo.m_90583_();
        for (Vector3f vertex : this.vertexes) {
            pBuffer.m_5483_((double)vertex.x - camPos.f_82479_, (double)vertex.y - camPos.f_82480_, (double)vertex.z - camPos.f_82481_).m_85950_(0.45f, 0.45f, 0.5f, this.f_107230_).m_5752_();
        }
    }

    public void m_5989_() {
        if (this.f_107224_++ > this.f_107225_) {
            this.m_107274_();
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public static class Provider
    implements ParticleProvider<LightningParticleOptions> {
        @Nullable
        public Particle createParticle(LightningParticleOptions pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new LightningParticle(pLevel, pType.getStart(), pType.getEnd(), pType.getSegments(), pType.getLifetime(), pType.getDisplacement(), pType.getWidth());
        }
    }
}

