/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.particle.ShimmerShieldParticleOptions;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ShimmerShieldParticle
extends TextureSheetParticle {
    private final List<ShieldElement> elements = new ArrayList<ShieldElement>();
    private final Color min;
    private final Color max;
    private final Entity target;
    private final int maxElementsAmount;
    private final int minRegenTime;
    private final int maxRegenTime;
    private final int maxLifeTime;
    private final int minLifeTime;
    private int spawnTime;
    private final float maxSpeed;

    protected ShimmerShieldParticle(ClientLevel pLevel, Color min, Color max, Entity target, int maxElementsAmount, int minRegenTime, int maxRegenTime, float maxSpeed, int maxLifeTime, int minLifeTime) {
        super(pLevel, 0.0, 0.0, 0.0);
        this.min = min;
        this.max = max;
        this.target = target;
        this.maxElementsAmount = maxElementsAmount;
        this.minRegenTime = minRegenTime;
        this.maxRegenTime = maxRegenTime;
        this.maxSpeed = maxSpeed;
        this.maxLifeTime = maxLifeTime;
        this.minLifeTime = minLifeTime;
        this.fillRandom();
    }

    private void fillRandom() {
        for (int i = 0; i < this.maxElementsAmount; ++i) {
            this.elements.add(new ShieldElement());
        }
        this.elements.forEach(element -> {
            element.age = this.f_107223_.m_216332_(0, element.lifeTime);
        });
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.elements.removeIf(ShieldElement::tick);
        if (this.spawnTime-- <= 0 && this.elements.size() < this.maxElementsAmount) {
            this.elements.add(new ShieldElement());
            if (this.elements.size() < this.maxElementsAmount) {
                this.spawnTime = this.f_107223_.m_216332_(this.minRegenTime, this.maxRegenTime);
            }
        }
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        this.elements.forEach(shieldElement -> shieldElement.render(pBuffer, pRenderInfo.m_90583_(), pPartialTicks));
    }

    @NotNull
    public AABB m_107277_() {
        return this.target == null ? super.m_107277_() : this.target.m_20191_().m_82377_((double)this.target.m_20205_() * 0.4, (double)this.target.m_20206_() * 0.4, (double)this.target.m_20205_() * 0.4);
    }

    private class ShieldElement {
        private int age;
        private final int lifeTime;
        private final Dimension x;
        private final Dimension y;
        private final Dimension z;

        private ShieldElement(int lifeTime, Dimension x, Dimension y, Dimension z) {
            this.lifeTime = lifeTime;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private ShieldElement() {
            this(shimmerShieldParticle.f_107223_.m_216332_(shimmerShieldParticle.minLifeTime, shimmerShieldParticle.maxLifeTime), Dimension.random(shimmerShieldParticle.f_107223_, shimmerShieldParticle.maxSpeed), Dimension.random(shimmerShieldParticle.f_107223_, shimmerShieldParticle.maxSpeed), Dimension.random(shimmerShieldParticle.f_107223_, shimmerShieldParticle.maxSpeed));
        }

        private void render(VertexConsumer pBuffer, Vec3 camPos, float pPartialTicks) {
            Vec3 origin = ShimmerShieldParticle.this.target.m_20182_().m_82520_(0.0, (double)(ShimmerShieldParticle.this.target.m_20206_() / 2.0f), 0.0);
            Vec3 pos = origin.m_82549_(this.offset(pPartialTicks));
            Vec2 rot = MathHelper.createTargetRotationFromPos(pos, origin);
            Quaternionf quaternionf = new Quaternionf(rot.f_82470_ * ((float)Math.PI / 180), rot.f_82471_ * ((float)Math.PI / 180), 0.0f, 1.0f);
            Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
            Vec3 relative = pos.m_82546_(camPos);
            for (int i = 0; i < 4; ++i) {
                Vector3f vector3f = avector3f[i];
                vector3f.rotate((Quaternionfc)quaternionf);
                vector3f.mul(ShimmerShieldParticle.this.m_5902_(pPartialTicks));
                vector3f.add((Vector3fc)relative.m_252839_());
            }
            Color color = ShimmerShieldParticle.this.max.mix(ShimmerShieldParticle.this.min, ((float)Math.max(this.age - 1, 0) + pPartialTicks) / (float)this.lifeTime);
            float f6 = ShimmerShieldParticle.this.m_5970_();
            float f7 = ShimmerShieldParticle.this.m_5952_();
            float f4 = ShimmerShieldParticle.this.m_5951_();
            float f5 = ShimmerShieldParticle.this.m_5950_();
            int j = ShimmerShieldParticle.this.m_6355_(pPartialTicks);
            this.vertex(pBuffer, avector3f[0], f7, f5, color, j);
            this.vertex(pBuffer, avector3f[1], f7, f4, color, j);
            this.vertex(pBuffer, avector3f[2], f6, f4, color, j);
            this.vertex(pBuffer, avector3f[3], f6, f5, color, j);
            this.vertex(pBuffer, avector3f[3], f7, f5, color, j);
            this.vertex(pBuffer, avector3f[2], f7, f4, color, j);
            this.vertex(pBuffer, avector3f[1], f6, f4, color, j);
            this.vertex(pBuffer, avector3f[0], f6, f5, color, j);
        }

        private void vertex(VertexConsumer pBuffer, Vector3f vector3f, float f7, float f5, Color color, int j) {
            pBuffer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(f7, f5).m_85950_(color.r(), color.g(), color.b(), color.a()).m_85969_(j).m_5752_();
        }

        private boolean tick() {
            this.x.tick();
            this.y.tick();
            this.z.tick();
            return this.age++ >= this.lifeTime;
        }

        private Vec3 offset(float partialTick) {
            return new Vec3((double)this.x.getOffset(partialTick) * 0.8 * (double)ShimmerShieldParticle.this.target.m_20205_(), (double)this.y.getOffset(partialTick) * 0.8 * (double)ShimmerShieldParticle.this.target.m_20206_(), (double)this.z.getOffset(partialTick) * 0.8 * (double)ShimmerShieldParticle.this.target.m_20205_());
        }

        private static class Dimension {
            private final float speed;
            private float pos;
            private float oPos;

            private Dimension(float speed, float pos) {
                this.speed = speed;
                this.pos = pos;
            }

            private static Dimension random(RandomSource source, float maxSpeed) {
                return new Dimension(MathHelper.randomBetween(source, -maxSpeed, maxSpeed), MathHelper.randomBetween(source, 0.0f, 360.0f));
            }

            private float getOffset(float partialTick) {
                return Mth.m_14031_((float)Mth.m_14179_((float)partialTick, (float)this.oPos, (float)this.pos));
            }

            private void tick() {
                this.oPos = this.pos;
                this.pos += this.speed;
            }
        }
    }

    public static class Provider
    implements ParticleProvider.Sprite<ShimmerShieldParticleOptions> {
        @Nullable
        public TextureSheetParticle createParticle(ShimmerShieldParticleOptions pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new ShimmerShieldParticle(pLevel, pType.getMinColor(), pType.getMaxColor(), pLevel.m_6815_(pType.getEntityId()), pType.getMaxElements(), pType.getMinRegenTime(), pType.getMaxRegenTime(), pType.getMaxSpeed(), pType.getMaxLifeTime(), pType.getMinLifeTime());
        }
    }
}

