/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.elements;

import java.util.Objects;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ElementTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MoveTowardsBBElement
implements AnimationElement {
    private final int entity;
    private final int duration;

    public MoveTowardsBBElement(int entity, int duration) {
        this.entity = entity;
        this.duration = duration;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Type getType() {
        return (Type)ElementTypes.MOVE_TOWARDS_BB.get();
    }

    @Override
    public int createLength(ParticleConfig config) {
        return this.duration;
    }

    @Override
    public void initialize(ParticleConfig object) {
        object.setProperty("target", MathHelper.randomIn(KapLibMod.RANDOM_SOURCE, ClientHelper.getEntity(this.entity).m_20191_()).m_82546_(ClientHelper.getEntity(this.entity).m_20182_()));
        object.setProperty("origin", object.pos());
    }

    @Override
    public void tick(ParticleConfig object, int tick, double percentage) {
        object.setPos(((Vec3)object.getProperty("origin")).m_165921_(((Vec3)object.getProperty("target")).m_82549_(ClientHelper.getEntity(this.entity).m_20182_()), percentage));
    }

    public static class Builder
    implements AnimationElement.Builder {
        private Entity entity;
        private int duration;

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder target(Entity entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public AnimationElement build() {
            if (this.duration < 1) {
                throw new IllegalStateException("MoveTowardsBB duration must be larger than 0");
            }
            return new MoveTowardsBBElement(Objects.requireNonNull(this.entity, "MoveTowardsBB without entity found!").m_19879_(), this.duration);
        }
    }

    public static class Type
    implements AnimationElement.Type<MoveTowardsBBElement> {
        @Override
        public MoveTowardsBBElement fromNW(FriendlyByteBuf buf) {
            return new MoveTowardsBBElement(buf.readInt(), buf.readInt());
        }

        @Override
        public void toNW(FriendlyByteBuf buf, MoveTowardsBBElement value) {
            buf.writeInt(value.entity);
            buf.writeInt(value.duration);
        }
    }
}

