/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class GroupSpawner
implements Spawner {
    private final Spawner[] spawners;

    public GroupSpawner(Spawner[] spawners) {
        this.spawners = spawners;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        for (Spawner spawner : this.spawners) {
            spawner.spawn(sink);
        }
    }

    @NotNull
    public Type getType() {
        return (Type)SpawnerTypes.GROUP.get();
    }

    public static class Builder
    implements Spawner.Builder {
        private final List<Spawner> spawners = new ArrayList<Spawner>();

        public Builder addSpawner(Spawner.Builder spawner) {
            this.spawners.add(spawner.build());
            return this;
        }

        @Override
        public Spawner build() {
            return new GroupSpawner((Spawner[])this.spawners.toArray(Spawner[]::new));
        }
    }

    public static class Type
    implements Spawner.Type<GroupSpawner> {
        @Override
        public void toNW(FriendlyByteBuf buf, GroupSpawner value) {
            NetworkHelper.writeArray(buf, value.spawners, Spawner::toNw);
        }

        @Override
        public GroupSpawner fromNw(FriendlyByteBuf buf, ClientLevel level) {
            return new GroupSpawner((Spawner[])NetworkHelper.readArray(buf, Spawner[]::new, Spawner::fromNw));
        }
    }
}

