/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import java.util.Objects;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Spawner {
    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public static Spawner fromNw(FriendlyByteBuf buf) {
        Type type = (Type)buf.readRegistryIdUnsafe(ExtraRegistries.SPAWN_ELEMENT_TYPES);
        return type.fromNw(buf, Minecraft.m_91087_().f_91073_);
    }

    @ApiStatus.Internal
    public static <T extends Spawner> void toNw(FriendlyByteBuf buf, T element) {
        Type<? extends Spawner> type = Objects.requireNonNull(element.getType(), "element " + element + " does not declare type!");
        buf.writeRegistryIdUnsafe(ExtraRegistries.SPAWN_ELEMENT_TYPES, type);
        type.toNW(buf, element);
    }

    public void spawn(ParticleSpawnSink var1);

    @NotNull
    public Type<? extends Spawner> getType();

    public static interface Type<T extends Spawner> {
        public void toNW(FriendlyByteBuf var1, T var2);

        @OnlyIn(value=Dist.CLIENT)
        public T fromNw(FriendlyByteBuf var1, ClientLevel var2);
    }

    public static interface Builder {
        public Spawner build();
    }
}

