/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.crafting.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeItemRecipe
extends CustomRecipe {
    private final Ingredient toUpgrade;
    private final Ingredient upgradeItem;
    private final ItemStack result;
    private final String group;
    private final CraftType type;

    public UpgradeItemRecipe(ResourceLocation p_252125_, CraftingBookCategory p_249010_, Ingredient toUpgrade, Ingredient upgradeItem, ItemStack result, String group, CraftType type) {
        super(p_252125_, p_249010_);
        this.toUpgrade = toUpgrade;
        this.upgradeItem = upgradeItem;
        this.result = result;
        this.group = group;
        this.type = type;
    }

    public boolean matches(@NotNull CraftingContainer craftingContainer, @NotNull Level level) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (!this.type.test(x, y)) continue;
                required.add(craftingContainer.m_8020_(x + y * 3));
            }
        }
        return this.toUpgrade.test(craftingContainer.m_8020_(4)) && required.stream().allMatch(this.upgradeItem);
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        ItemStack source = pContainer.m_8020_(4);
        ItemStack result = this.result.m_41777_();
        result.m_41751_(source.m_41783_());
        return result;
    }

    public Ingredient getUpgradeItem() {
        return this.upgradeItem;
    }

    public Ingredient getToUpgrade() {
        return this.toUpgrade;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public CraftType getCraftType() {
        return this.type;
    }

    public boolean m_8004_(int i, int j) {
        return i == 3 && j == 3;
    }

    @NotNull
    public RecipeSerializer<UpgradeItemRecipe> m_7707_() {
        return (RecipeSerializer)ExtraRecipeSerializers.UPGRADE_ITEM.get();
    }

    public static enum CraftType implements StringRepresentable,
    BiPredicate<Integer, Integer>
    {
        EIGHT("eight", (x, y) -> x + 3 * y != 4),
        FOUR("four", (x, y) -> EIGHT.test(x, y) && x == 1 && y % 2 == 0 || y == 1 && x % 2 == 0),
        FOUR_DIAGONAL("four_diagonal", (x, y) -> EIGHT.test(x, y) && x % 2 == 0 && y % 2 == 0);

        static final StringRepresentable.EnumCodec<CraftType> CODEC;
        private final String name;
        private final PositionPredicate applyPredicate;

        private CraftType(String name, PositionPredicate applyPredicate) {
            this.name = name;
            this.applyPredicate = applyPredicate;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        @Override
        public boolean test(Integer integer, Integer integer2) {
            return this.applyPredicate.apply(integer, integer2);
        }

        static {
            CODEC = StringRepresentable.m_216439_(CraftType::values);
        }
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeItemRecipe> {
        @NotNull
        public UpgradeItemRecipe fromJson(@NotNull ResourceLocation location, @NotNull JsonObject jsonObject) {
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Ingredient source = Ingredient.m_43917_((JsonElement)jsonObject.get("source"));
            Ingredient upgradeItem = Ingredient.m_43917_((JsonElement)jsonObject.get("material"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)jsonObject.getAsJsonObject("result"));
            CraftType type = (CraftType)CraftType.CODEC.m_216455_(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"craft_type"));
            return new UpgradeItemRecipe(location, craftingbookcategory, source, upgradeItem, result, s, type);
        }

        @Nullable
        public UpgradeItemRecipe fromNetwork(@NotNull ResourceLocation location, @NotNull FriendlyByteBuf buf) {
            String s = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            Ingredient source = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient upgradeItem = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack stack = buf.m_130267_();
            CraftType type = (CraftType)buf.m_130066_(CraftType.class);
            return new UpgradeItemRecipe(location, category, source, upgradeItem, stack, s, type);
        }

        public void toNetwork(FriendlyByteBuf buf, UpgradeItemRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.m_130068_((Enum)recipe.m_245232_());
            recipe.toUpgrade.m_43923_(buf);
            recipe.upgradeItem.m_43923_(buf);
            buf.m_130055_(recipe.result);
            buf.m_130068_((Enum)recipe.type);
        }
    }

    private static interface PositionPredicate {
        public boolean apply(int var1, int var2);
    }
}

