/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import com.google.common.hash.HashCode;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntUnaryOperator;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextureProvider
implements DataProvider {
    private static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
    private final ExistingFileHelper existingFileHelper;
    private final PackOutput output;
    private final List<Pipeline.Builder> converters = new ArrayList<Pipeline.Builder>();

    public TextureProvider(ExistingFileHelper existingFileHelper, PackOutput output) {
        this.existingFileHelper = existingFileHelper;
        this.output = output;
    }

    public static int getAlpha(int rgbaPixel) {
        return rgbaPixel >> 24 & 0xFF;
    }

    public static List<Color> loadOpaquePixels(NativeImage image, @Nullable NativeImage mask) {
        ArrayList<Color> pixels = new ArrayList<Color>();
        for (int y = 0; y < image.m_85084_(); ++y) {
            for (int x = 0; x < image.m_84982_(); ++x) {
                int maskAlpha;
                int pixel = image.m_84985_(x, y);
                int alpha = TextureProvider.getAlpha(pixel);
                int n = maskAlpha = mask == null ? 255 : TextureProvider.getAlpha(mask.m_84985_(x, y));
                if (maskAlpha == 0 || alpha == 0) continue;
                pixels.add(Color.fromARGBPacked(pixel));
            }
        }
        return pixels;
    }

    public static double colorDistance(Color c1, Color c2) {
        float dr = c1.r() - c2.r();
        float dg = c1.g() - c2.g();
        float db = c1.b() - c2.b();
        return Math.sqrt(dr * dr + dg * dg + db * db);
    }

    public static List<Color> getMostUniqueColors(List<Color> pixels, int n) {
        if (pixels.isEmpty()) {
            return new ArrayList<Color>();
        }
        HashMap<Color, Integer> counter = new HashMap<Color, Integer>();
        for (Color pixel : pixels) {
            counter.merge(pixel, 1, Integer::sum);
        }
        ArrayList<Color> uniqueColors = new ArrayList<Color>(counter.keySet());
        if (uniqueColors.size() <= n) {
            return uniqueColors;
        }
        ArrayList<Color> selected = new ArrayList<Color>();
        Color mostFrequent = (Color)counter.entrySet().stream().max(Map.Entry.comparingByValue()).get().getKey();
        selected.add(mostFrequent);
        while (selected.size() < n) {
            Color bestColor = null;
            double bestDistance = -1.0;
            for (Color color : uniqueColors) {
                double minDist;
                if (selected.contains(color) || !((minDist = selected.stream().mapToDouble(s -> TextureProvider.colorDistance(color, s)).min().orElse(0.0)) > bestDistance)) continue;
                bestDistance = minDist;
                bestColor = color;
            }
            if (bestColor == null) break;
            selected.add(bestColor);
        }
        return selected;
    }

    public static double brightness(Color color) {
        return 0.2126 * (double)color.r() + 0.7152 * (double)color.g() + 0.0722 * (double)color.b();
    }

    public static List<Color> sortByBrightness(List<Color> colors) {
        ArrayList<Color> sorted = new ArrayList<Color>(colors);
        sorted.sort(Comparator.comparingDouble(TextureProvider::brightness));
        return sorted;
    }

    public static List<Color> getPalette(NativeImage image, NativeImage mask, int paletteSize) {
        List<Color> opaquePixels = TextureProvider.loadOpaquePixels(image, mask);
        List<Color> uniqueColors = TextureProvider.getMostUniqueColors(opaquePixels, paletteSize);
        return TextureProvider.sortByBrightness(uniqueColors);
    }

    public static List<Color> expandToLength(List<Color> src, int targetLen) {
        if (src.isEmpty()) {
            throw new IllegalArgumentException("Cannot expand an empty palette");
        }
        if (targetLen <= src.size()) {
            return new ArrayList<Color>(src.subList(0, targetLen));
        }
        ArrayList<Color> result = new ArrayList<Color>();
        int nSrc = src.size();
        for (int i = 0; i < targetLen; ++i) {
            float pos = (float)i / ((float)targetLen - 1.0f);
            Color color = TextureProvider.getColor(src, pos, nSrc);
            result.add(color);
        }
        return result;
    }

    private static Color getColor(List<Color> src, float pos, int nSrc) {
        Color color;
        float srcPos = pos * (float)(nSrc - 1);
        int idx = (int)srcPos;
        float frac = srcPos - (float)idx;
        if (idx >= nSrc - 1) {
            color = src.get(nSrc - 1);
        } else {
            Color c1 = src.get(idx);
            Color c2 = src.get(idx + 1);
            color = c1.mix(c2, frac);
        }
        return color;
    }

    public static IntUnaryOperator makeColorMapper(List<Color> srcColors, List<Color> dstColors) {
        List<Color> sortedSrc = TextureProvider.sortByBrightness(new ArrayList<Color>(srcColors));
        List<Color> sortedDst = TextureProvider.sortByBrightness(new ArrayList<Color>(dstColors));
        if (sortedSrc.size() > sortedDst.size()) {
            sortedDst = TextureProvider.expandToLength(sortedDst, sortedSrc.size());
        } else if (sortedSrc.size() < sortedDst.size()) {
            sortedDst = TextureProvider.sortByBrightness(TextureProvider.getMostUniqueColors(sortedDst, sortedSrc.size()));
        }
        HashMap<Color, Color> mapping = new HashMap<Color, Color>();
        for (int i = 0; i < sortedSrc.size(); ++i) {
            mapping.put(sortedSrc.get(i), sortedDst.get(i));
        }
        return rgbaPixel -> {
            int alpha = TextureProvider.getAlpha(rgbaPixel);
            Color color = Color.fromARGBPacked(rgbaPixel);
            Color newColor = (Color)mapping.get(color);
            if (newColor != null) {
                return newColor.pack() & 0xFFFFFF | (alpha & 0xFF) << 24;
            }
            return rgbaPixel;
        };
    }

    public static NativeImage remapTexture(NativeImage paletteSource, NativeImage patternSource, NativeImage maskSource, int paletteSize) {
        List<Color> sourcePalette = TextureProvider.getPalette(paletteSource, null, paletteSize);
        List<Color> patternPalette = TextureProvider.getPalette(patternSource, maskSource, paletteSize);
        IntUnaryOperator mapper = TextureProvider.makeColorMapper(patternPalette, sourcePalette);
        return patternSource.m_266528_(mapper);
    }

    public static NativeImage remapTexture(NativeImage paletteSource, NativeImage targetTexture, NativeImage maskSource) {
        return TextureProvider.remapTexture(paletteSource, targetTexture, maskSource, 256);
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput output) {
        this.createEntries();
        return CompletableFuture.allOf((CompletableFuture[])this.converters.stream().map(Pipeline.Builder::build).map(p -> {
            if (!this.existingFileHelper.exists(p.in, (ExistingFileHelper.IResourceType)TEXTURE)) {
                throw new IllegalArgumentException("in target doesn't exist: " + p.in);
            }
            for (Converter pass : p.passes) {
                pass.validate(this.existingFileHelper);
            }
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)this.existingFileHelper.getResource(p.in, PackType.CLIENT_RESOURCES, ".png", "textures").m_215507_());
                for (Converter pass : p.passes) {
                    NativeImage out = pass.convert(image, this.existingFileHelper);
                    image.close();
                    image = out;
                }
                this.existingFileHelper.trackGenerated(p.output, (ExistingFileHelper.IResourceType)TEXTURE);
                Path path = this.output.m_245269_(PackOutput.Target.RESOURCE_PACK, "textures").m_245527_(p.output, "png");
                byte[] bytes = image.m_85121_();
                image.close();
                return CompletableFuture.runAsync(() -> {
                    try {
                        output.m_213871_(path, bytes, HashCode.fromBytes((byte[])bytes));
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Unable to store image: " + ex.getMessage());
                    }
                });
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }).toArray(CompletableFuture[]::new));
    }

    protected abstract void createEntries();

    @NotNull
    public String m_6055_() {
        return "ImagePaletteMapper";
    }

    protected Pipeline.Builder register(ResourceLocation in, ResourceLocation out) {
        Pipeline.Builder builder = new Pipeline.Builder(out, in);
        this.converters.add(builder);
        return builder;
    }

    protected void registerOre(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/raw_")).then(Transfer.create(new ResourceLocation("item/raw_gold")));
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_dust")).then(Transfer.create(new ResourceLocation("item/glowstone_dust")));
    }

    protected void registerTools(ResourceLocation paletteSource, ResourceLocation name) {
        this.registerHoe(paletteSource, name);
        this.registerSword(paletteSource, name);
        this.registerPickaxe(paletteSource, name);
        this.registerShovel(paletteSource, name);
        this.registerAxe(paletteSource, name);
    }

    protected void registerHoe(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_hoe")).then(Transfer.createWithMask(new ResourceLocation("item/golden_hoe"), KapLibMod.res("item/mask/hoe")));
    }

    protected void registerSword(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_sword")).then(Transfer.createWithMask(new ResourceLocation("item/golden_sword"), KapLibMod.res("item/mask/sword")));
    }

    protected void registerPickaxe(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_pickaxe")).then(Transfer.createWithMask(new ResourceLocation("item/golden_pickaxe"), KapLibMod.res("item/mask/pickaxe")));
    }

    protected void registerShovel(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_shovel")).then(Transfer.createWithMask(new ResourceLocation("item/golden_shovel"), KapLibMod.res("item/mask/shovel")));
    }

    protected void registerAxe(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_axe")).then(Transfer.createWithMask(new ResourceLocation("item/golden_axe"), KapLibMod.res("item/mask/axe")));
    }

    protected void registerNetheriteArmor(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_helmet")).then(Transfer.create(new ResourceLocation("item/netherite_helmet")));
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_chestplate")).then(Transfer.create(new ResourceLocation("item/netherite_chestplate")));
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_leggings")).then(Transfer.create(new ResourceLocation("item/netherite_leggings")));
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_boots")).then(Transfer.create(new ResourceLocation("item/netherite_boots")));
        this.register(paletteSource, name.m_246208_("models/armor/").m_266382_("_layer_1")).then(Transfer.create(new ResourceLocation("models/armor/netherite_layer_1")));
        this.register(paletteSource, name.m_246208_("models/armor/").m_266382_("_layer_2")).then(Transfer.create(new ResourceLocation("models/armor/netherite_layer_2")));
    }

    protected void registerDiamondArmor(ResourceLocation paletteSource, ResourceLocation name) {
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_helmet")).then(Transfer.create(new ResourceLocation("item/diamond_helmet")));
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_chestplate")).then(Transfer.create(new ResourceLocation("item/diamond_chestplate")));
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_leggings")).then(Transfer.create(new ResourceLocation("item/diamond_leggings")));
        this.register(paletteSource, name.m_246208_("item/").m_266382_("_boots")).then(Transfer.create(new ResourceLocation("item/diamond_boots")));
        this.register(paletteSource, name.m_246208_("models/armor/").m_266382_("_layer_1")).then(Transfer.create(new ResourceLocation("models/armor/diamond_layer_1")));
        this.register(paletteSource, name.m_246208_("models/armor/").m_266382_("_layer_2")).then(Transfer.create(new ResourceLocation("models/armor/diamond_layer_2")));
    }

    protected record Pipeline(ResourceLocation in, ResourceLocation output, Converter[] passes) {

        public static class Builder {
            private final ResourceLocation output;
            private final ResourceLocation input;
            private final List<Converter> converters = new ArrayList<Converter>();

            private Builder(ResourceLocation output, ResourceLocation input) {
                this.output = output;
                this.input = input;
            }

            public Builder then(Converter converter) {
                this.converters.add(converter);
                return this;
            }

            public Pipeline build() {
                return new Pipeline(this.input, this.output, (Converter[])this.converters.toArray(Converter[]::new));
            }
        }
    }

    protected record Transfer(ResourceLocation patternSource, ResourceLocation mask) implements Converter
    {
        public static Transfer create(ResourceLocation patternSource) {
            return new Transfer(patternSource, null);
        }

        public static Transfer createWithMask(ResourceLocation patternSource, ResourceLocation maskSource) {
            return new Transfer(patternSource, maskSource);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NativeImage convert(NativeImage in, ExistingFileHelper existingFileHelper) {
            try (NativeImage patternSource = NativeImage.m_85058_((InputStream)existingFileHelper.getResource(this.patternSource, PackType.CLIENT_RESOURCES, ".png", "textures").m_215507_());){
                if (this.mask != null) {
                    try (NativeImage mask = NativeImage.m_85058_((InputStream)existingFileHelper.getResource(this.mask, PackType.CLIENT_RESOURCES, ".png", "textures").m_215507_());){
                        NativeImage nativeImage = TextureProvider.remapTexture(in, patternSource, mask);
                        return nativeImage;
                    }
                }
                NativeImage nativeImage = TextureProvider.remapTexture(in, patternSource, null);
                return nativeImage;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void validate(ExistingFileHelper helper) {
            if (!helper.exists(this.patternSource, (ExistingFileHelper.IResourceType)TEXTURE)) {
                throw new IllegalStateException("unable to find pattern source: " + this.patternSource);
            }
        }
    }

    protected static interface Converter {
        public NativeImage convert(NativeImage var1, ExistingFileHelper var2);

        default public void validate(ExistingFileHelper helper) {
        }
    }

    protected record Invert() implements Converter
    {
        public static Invert create() {
            return new Invert();
        }

        @Override
        public NativeImage convert(NativeImage in, ExistingFileHelper helper) {
            return in.m_266528_(i -> {
                for (int j = 0; j < 3; ++j) {
                    int val = 255 - (i >> j * 8) & 0xFF;
                    int mask = 255 << j * 8;
                    i = i & ~mask | val << j * 8;
                }
                return i;
            });
        }
    }

    protected record BlueShade() implements Converter
    {
        public static BlueShade create() {
            return new BlueShade();
        }

        @Override
        public NativeImage convert(NativeImage in, ExistingFileHelper helper) {
            return in.m_266528_(i -> i & 0xFF0000FF);
        }
    }

    protected record GreenShade() implements Converter
    {
        public static GreenShade create() {
            return new GreenShade();
        }

        @Override
        public NativeImage convert(NativeImage in, ExistingFileHelper helper) {
            return in.m_266528_(i -> i & 0xFF00FF00);
        }
    }

    protected record RedShade() implements Converter
    {
        public static RedShade create() {
            return new RedShade();
        }

        @Override
        public NativeImage convert(NativeImage in, ExistingFileHelper helper) {
            return in.m_266528_(i -> i & 0xFFFF0000);
        }
    }
}

