/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.extras;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColorManager;
import net.kapitencraft.kap_lib.client.glyph.enchantment_applicable.EnchantmentApplicableAllocator;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.enchantments.abstracts.ModEnchantment;
import net.kapitencraft.kap_lib.event.custom.client.RegisterEnchantmentApplicableCharsEvent;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EnchantmentDescriptionManager {
    private static final Style INFO_STYLE = Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131136_(Boolean.valueOf(false)).m_178522_(Boolean.valueOf(false)).m_131155_(Boolean.valueOf(false)).m_178524_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false));
    private static final ResourceLocation INFO_FONT_LOCATION = KapLibMod.res("enchantment_info");
    private static final ResourceLocation APPLICABLE_FONT_LOCATION = KapLibMod.res("enchantment_applicable");
    private static final char NO_TRADING = '\uf000';
    private static final char TREASURE = '\uf001';
    private static final List<Pair<Item, Character>> applicableMap = new ArrayList<Pair<Item, Character>>();
    private static final Map<Enchantment, String> applicableCache = new HashMap<Enchantment, String>();

    public static void addAllTooltips(ItemStack stack, List<Component> tooltips, ListTag pStoredEnchantments, Player player) {
        if (pStoredEnchantments.isEmpty()) {
            return;
        }
        if (!Screen.m_96638_()) {
            tooltips.add((Component)Component.m_237115_((String)"ench_desc.shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
        for (int i = 0; i < pStoredEnchantments.size(); ++i) {
            CompoundTag compoundtag = pStoredEnchantments.m_128728_(i);
            Optional.ofNullable((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)compoundtag))).ifPresent(ench -> {
                int level = EnchantmentHelper.m_182438_((CompoundTag)compoundtag);
                MutableComponent component = Component.m_237119_();
                component.m_7220_((Component)((MutableComponent)ench.m_44700_(level)).m_130948_(MiscHelper.nonNullOr(EnchantmentColorManager.getStyle(ench, level), Style.f_131099_)));
                if (EnchantmentDescriptionManager.fromBook(stack.m_41720_())) {
                    if (ClientModConfig.showObtainDisplay()) {
                        component.m_7220_(CommonComponents.f_263701_);
                        component.m_7220_((Component)Component.m_237113_((String)EnchantmentDescriptionManager.addObtainDisplay(ench)).m_130948_(INFO_STYLE.m_131150_(INFO_FONT_LOCATION)));
                    }
                    if (ClientModConfig.showApplyDisplay()) {
                        component.m_7220_(CommonComponents.f_263701_);
                        component.m_7220_((Component)Component.m_237113_((String)EnchantmentDescriptionManager.getApplicable(ench)).m_130948_(INFO_STYLE.m_131150_(APPLICABLE_FONT_LOCATION)));
                    }
                }
                tooltips.add((Component)component);
                if (Screen.m_96638_()) {
                    EnchantmentDescriptionManager.addTooltipForEnchant(tooltips, ench, player, level);
                }
                ClientHelper.addReqContent(tooltips::add, RegistryReqType.ENCHANTMENT, ench, (LivingEntity)player);
            });
        }
    }

    public static String addObtainDisplay(Enchantment enchantment) {
        Object s = "";
        if (enchantment.m_6591_()) {
            s = (String)s + "\uf001";
        }
        if (!enchantment.m_6594_()) {
            s = (String)s + "\uf000";
        }
        return s;
    }

    public static void addTooltipForEnchant(List<Component> list, Enchantment enchantment, Player player, int level) {
        list.addAll(EnchantmentDescriptionManager.getDescription(enchantment, level));
    }

    public static boolean fromBook(Item item) {
        return item instanceof EnchantedBookItem;
    }

    public static List<Component> getDescription(Enchantment ench, int level) {
        Object[] objectArray;
        if (ench instanceof ModEnchantment) {
            ModEnchantment modEnchantment = (ModEnchantment)ench;
            objectArray = modEnchantment.getDescriptionMods(level);
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = level;
        }
        Object[] objects = objectArray;
        Stream<String> stream = Arrays.stream(objects).map(String::valueOf);
        return TextHelper.getDescriptionOrEmpty(ench.m_44704_(), component -> component.m_130940_(ChatFormatting.DARK_GRAY), stream.map(TextHelper::wrapInRed).toArray());
    }

    private static void addItem(Item item, ResourceLocation location) {
        applicableMap.add((Pair<Item, Character>)Pair.of((Object)item, (Object)Character.valueOf(EnchantmentApplicableAllocator.getInstance().addEntry(location))));
    }

    private static void addItem(Item item) {
        EnchantmentDescriptionManager.addItem(item, ForgeRegistries.ITEMS.getKey((Object)item).m_246208_("item/"));
    }

    public static void initApplication() {
        EnchantmentDescriptionManager.addItem(Items.f_42475_);
        EnchantmentDescriptionManager.addItem(Items.f_42474_);
        EnchantmentDescriptionManager.addItem(Items.f_42473_);
        EnchantmentDescriptionManager.addItem(Items.f_42472_);
        EnchantmentDescriptionManager.addItem(Items.f_42390_);
        EnchantmentDescriptionManager.addItem(Items.f_42391_);
        EnchantmentDescriptionManager.addItem(Items.f_42392_);
        EnchantmentDescriptionManager.addItem(Items.f_42411_);
        EnchantmentDescriptionManager.addItem(Items.f_42717_, new ResourceLocation("item/crossbow_standby"));
        EnchantmentDescriptionManager.addItem(Items.f_42741_);
        EnchantmentDescriptionManager.addItem(Items.f_42574_);
        EnchantmentDescriptionManager.addItem(Items.f_42713_);
        EnchantmentDescriptionManager.addItem(Items.f_42523_);
        MinecraftForge.EVENT_BUS.post((Event)new RegisterEnchantmentApplicableCharsEvent(EnchantmentDescriptionManager::addItem, EnchantmentDescriptionManager::addItem));
    }

    private static String getApplicable(Enchantment enchantment) {
        if (applicableMap.isEmpty()) {
            EnchantmentDescriptionManager.initApplication();
        }
        if (applicableCache.containsKey(enchantment)) {
            return applicableCache.get(enchantment);
        }
        EnchantmentCategory category = enchantment.f_44672_;
        StringBuilder s = new StringBuilder();
        for (Pair<Item, Character> test : applicableMap) {
            if (!category.m_7454_((Item)test.getFirst())) continue;
            s.append(test.getSecond());
        }
        String value = s.toString();
        applicableCache.put(enchantment, value);
        return value;
    }
}

