/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.event;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.elements.MoveTowardsBBElement;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.RemoveParticleFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.EntityBBSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.EntityRemovedTerminatorTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.TimedTerminator;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.enchantments.abstracts.ExtendedCalculationEnchantment;
import net.kapitencraft.kap_lib.enchantments.abstracts.IToolEnchantment;
import net.kapitencraft.kap_lib.enchantments.abstracts.ModBowEnchantment;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.InventoryHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.io.network.ModMessages;
import net.kapitencraft.kap_lib.io.network.S2C.DisplayTotemActivationPacket;
import net.kapitencraft.kap_lib.item.bonus.BonusManager;
import net.kapitencraft.kap_lib.item.combat.totem.AbstractTotemItem;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.util.DamageCounter;
import net.kapitencraft.kap_lib.util.FerociousDamageSource;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber
@ApiStatus.Internal
public class DamageEvents {
    private DamageEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void miscDamageEvents(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntity();
        LivingEntity attacker = MiscHelper.getAttacker(event.getSource());
        event.setAmount(BonusManager.attackEvent(attacked, attacker, MiscHelper.getDamageType(event.getSource()), event.getAmount()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utilDamage(LivingDamageEvent event) {
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        boolean dodge = false;
        double dodgePercentage = AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.DODGE.get(), attacked);
        if (dodgePercentage > 0.0 && MathHelper.chance(dodgePercentage / 100.0, attacked) && (!source.m_269533_(DamageTypeTags.f_268490_) && !source.m_269533_(DamageTypeTags.f_268549_) && !source.m_269533_(DamageTypeTags.f_268745_) || source.m_276093_(DamageTypes.f_268669_))) {
            dodge = true;
            event.setAmount(0.0f);
        }
        MiscHelper.createDamageIndicator(attacked, event.getAmount(), dodge ? "dodge" : source.m_19385_(), false);
        DamageCounter.increaseDamage(event.getAmount());
    }

    @SubscribeEvent
    public static void critDamageRegister(CriticalHitEvent event) {
        Player attacker = event.getEntity();
        if (event.isVanillaCritical() || AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.CRIT_CHANCE.get(), (LivingEntity)attacker) / 100.0 > Math.random()) {
            event.setResult(Event.Result.ALLOW);
            event.setDamageModifier((float)(1.0 + AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.CRIT_DAMAGE.get(), (LivingEntity)attacker) / 100.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void ferocityRegister(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        LivingEntity attacker = MiscHelper.getAttacker(source);
        if (attacker == null || MiscHelper.getDamageType(source) != MiscHelper.DamageType.MELEE) {
            return;
        }
        if (attacker.m_21051_((Attribute)ExtraAttributes.FEROCITY.get()) != null) {
            double ferocity;
            if (source instanceof FerociousDamageSource) {
                FerociousDamageSource damageSource = (FerociousDamageSource)source;
                v0 = damageSource.ferocity;
            } else {
                v0 = ferocity = attacker.m_21133_((Attribute)ExtraAttributes.FEROCITY.get());
            }
            if (MathHelper.chance(ferocity / 100.0, attacker)) {
                MiscHelper.schedule(40, () -> {
                    double d;
                    if (source instanceof FerociousDamageSource) {
                        FerociousDamageSource ferociousDamageSource = (FerociousDamageSource)source;
                        d = ferociousDamageSource.damage;
                    } else {
                        Entity patt6047$temp = source.m_7639_();
                        if (patt6047$temp instanceof AbstractArrow) {
                            AbstractArrow arrow = (AbstractArrow)patt6047$temp;
                            d = arrow.m_36789_();
                        } else {
                            d = attacker.m_21133_(Attributes.f_22281_);
                        }
                    }
                    float ferocityDamage = (float)d;
                    if (attacked.m_21224_()) {
                        return;
                    }
                    attacked.m_9236_().m_245803_((Entity)attacked, attacked.m_20097_(), SoundEvents.f_12057_, SoundSource.HOSTILE, 1.0f, 0.5f);
                    attacked.m_6469_((DamageSource)FerociousDamageSource.create((Entity)attacker, ferocity - 100.0, ferocityDamage), ferocityDamage);
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void damageBonusRegister(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntity();
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            CompoundTag tag = arrow.getPersistentData();
            event.setAmount(ModBowEnchantment.loadFromTag(attacked, tag, ModBowEnchantment.ExePhase.HIT, event.getAmount(), (AbstractArrow)arrow));
            if (tag.m_128451_("OverloadEnchant") > 0 && arrow.m_36792_() && MathHelper.chance(0.1, arrow.m_19749_())) {
                event.setAmount((float)((double)(event.getAmount() * 1.0f) + (double)tag.m_128451_("OverloadEnchant") * 0.1));
            }
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity attacker = MiscHelper.getAttacker(source);
        if (attacker == null) {
            return;
        }
        MiscHelper.DamageType type = MiscHelper.getDamageType(source);
        ItemStack stack = attacker.m_21205_();
        Map enchantments = stack.getAllEnchantments();
        if (enchantments != null) {
            event.setAmount(ExtendedCalculationEnchantment.runWithPriority(stack, attacker, attacked, event.getAmount(), type, source));
            MiscHelper.getArmorEquipment(attacked).forEach(stack1 -> event.setAmount(ExtendedCalculationEnchantment.runWithPriority(stack1, attacker, attacked, event.getAmount(), type, source)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void damageAttributeRegister(LivingHurtEvent event) {
        double doubleJump;
        LivingEntity attacker = MiscHelper.getAttacker(event.getSource());
        if (attacker == null) {
            return;
        }
        if (MiscHelper.getDamageType(event.getSource()) == MiscHelper.DamageType.MELEE && attacker.m_21204_().m_22171_((Attribute)ExtraAttributes.STRENGTH.get())) {
            double strength = AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.STRENGTH.get(), attacker);
            MathHelper.mul(() -> ((LivingHurtEvent)event).getAmount(), arg_0 -> ((LivingHurtEvent)event).setAmount(arg_0), (float)(1.0 + strength / 100.0));
        }
        if ((doubleJump = AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.DOUBLE_JUMP.get(), attacker)) > 0.0 && event.getSource().m_276093_(DamageTypes.f_268671_)) {
            event.setAmount(event.getAmount() * (1.0f - (float)doubleJump / 100.0f));
        }
        LivingEntity attacked = event.getEntity();
        double armorShredder = AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.ARMOR_SHREDDER.get(), attacker);
        if (armorShredder > 0.0) {
            MiscHelper.getArmorEquipment(attacked).forEach(stack -> {
                ServerPlayer serverPlayer;
                stack.m_220157_((int)(armorShredder / 3.0), attacked.m_9236_().m_213780_(), attacker instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)attacker) : null);
            });
        }
        double liveSteal = AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.LIVE_STEAL.get(), attacker);
        if (!event.getSource().m_269014_() && liveSteal > 0.0) {
            Level level = attacker.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sL = (ServerLevel)level;
                ParticleAnimation.builder().spawn(((EntityBBSpawner.Builder)EntityBBSpawner.builder().setParticle((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)0x800000).m_252839_(), 0.3f))).target((Entity)attacked).perTick(150).scaleX(1.3f).scaleY(1.1f)).then(MoveTowardsBBElement.builder().target((Entity)attacker).duration(30)).finalizes(RemoveParticleFinalizer.builder()).spawnTime(ParticleAnimation.SpawnTime.once()).terminatedWhen(TimedTerminator.ticks(20)).terminatedWhen(EntityRemovedTerminatorTrigger.create((Entity)attacked)).terminatedWhen(EntityRemovedTerminatorTrigger.create((Entity)attacker)).sendToAllPlayers(sL, player -> player.m_20280_((Entity)attacked) < 1024.0);
            }
            attacker.m_5634_(Math.min((float)liveSteal, event.getAmount()));
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        event.setCanceled(!RequirementManager.meetsItemRequirementsFromEvent((LivingEvent)event, EquipmentSlot.MAINHAND));
    }

    @SubscribeEvent
    public static void shieldBlockEnchantments(ShieldBlockEvent event) {
        LivingEntity attacked = event.getEntity();
        LivingEntity attacker = MiscHelper.getAttacker(event.getDamageSource());
        if (attacker == null) {
            return;
        }
        ItemStack stack = attacker.m_21211_();
        MiscHelper.DamageType type = MiscHelper.getDamageType(event.getDamageSource());
        Map enchantments = stack.getAllEnchantments();
        if (enchantments != null && !enchantments.isEmpty()) {
            MapStream.of(enchantments).mapKeys(ExtendedCalculationEnchantment.class::cast).filterKeys(Objects::nonNull).filterKeys(ench -> ench instanceof IToolEnchantment).forEach((enchantment, integer) -> enchantment.tryExecute((int)integer, stack, attacker, attacked, event.getBlockedDamage(), type, event.getDamageSource()));
        }
    }

    @SubscribeEvent
    public static void entityDeathEvents(LivingDeathEvent event) {
        LivingEntity toDie = event.getEntity();
        if (toDie instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)toDie;
            Collection<ItemStack> totems = InventoryHelper.getByFilter((Player)player, stack -> stack.m_41720_() instanceof AbstractTotemItem);
            if (!event.isCanceled()) {
                for (ItemStack stack2 : totems) {
                    AbstractTotemItem totemItem = (AbstractTotemItem)stack2.m_41720_();
                    if (!totemItem.onUse((LivingEntity)player, event.getSource())) continue;
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)totemItem));
                    event.setCanceled(true);
                    ModMessages.sendToClientPlayer(new DisplayTotemActivationPacket(stack2.m_41777_(), player.m_19879_()), player);
                    stack2.m_41774_(1);
                    break;
                }
            }
        }
        if (!event.isCanceled()) {
            BonusManager.deathEvent(toDie, event.getSource());
        }
    }
}

