/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.ExtraComponents;
import net.kapitencraft.kap_lib.client.glyph.player_head.PlayerHeadAllocator;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.EntityRemovedTerminatorTrigger;
import net.kapitencraft.kap_lib.collection.Queue;
import net.kapitencraft.kap_lib.cooldown.Cooldowns;
import net.kapitencraft.kap_lib.cooldown.CooldownsProvider;
import net.kapitencraft.kap_lib.enchantments.abstracts.ModBowEnchantment;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.BonusHelper;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.helpers.ParticleHelper;
import net.kapitencraft.kap_lib.inventory.wearable.WearableProvider;
import net.kapitencraft.kap_lib.inventory.wearable.Wearables;
import net.kapitencraft.kap_lib.io.network.ModMessages;
import net.kapitencraft.kap_lib.io.network.S2C.SyncBonusesPacket;
import net.kapitencraft.kap_lib.io.network.S2C.SyncRequirementsPacket;
import net.kapitencraft.kap_lib.item.bonus.BonusManager;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.TerminatorTriggers;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.kapitencraft.kap_lib.spawn_table.SpawnTableManager;
import net.kapitencraft.kap_lib.tags.ExtraTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingMakeBrainEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber
@ApiStatus.Internal
public class Events {
    private static final List<Class<? extends LivingEvent>> dontCancel = List.of(EntityItemPickupEvent.class, ItemTooltipEvent.class, RenderPlayerEvent.Pre.class, RenderPlayerEvent.Post.class, PlayerEvent.LoadFromFile.class, PlayerEvent.NameFormat.class, PlayerEvent.TabListNameFormat.class, PlayerEvent.PlayerLoggedInEvent.class, PlayerEvent.PlayerLoggedOutEvent.class, MovementInputUpdateEvent.class, LivingMakeBrainEvent.class, LivingEvent.LivingTickEvent.class, LivingBreatheEvent.class);
    private static final Map<ResourceKey<Level>, Queue<UUID>> arrowHelper = new HashMap<ResourceKey<Level>, Queue<UUID>>();
    public static final String DOUBLE_JUMP_ID = "currentDoubleJump";

    @SubscribeEvent
    public static void ensureReqsMet(LivingEvent event) {
        if (!dontCancel.contains(event.getClass()) && !RequirementManager.meetsItemRequirementsFromEvent(event, EquipmentSlot.MAINHAND) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void addRequirementListener(AddReloadListenerEvent event) {
        RequirementManager.instance = new RequirementManager();
        event.addListener((PreparableReloadListener)RequirementManager.instance);
        event.addListener((PreparableReloadListener)BonusManager.updateInstance());
        SpawnTableManager.instance = new SpawnTableManager();
        event.addListener((PreparableReloadListener)SpawnTableManager.instance);
    }

    @SubscribeEvent
    public static void appendPlayerHead(PlayerEvent.NameFormat event) {
        event.setDisplayname((Component)ExtraComponents.playerHead(event.getEntity().m_20148_()).m_7220_(event.getDisplayname()));
    }

    @SubscribeEvent
    public static void playerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModMessages.sendToClientPlayer(new SyncRequirementsPacket(RequirementManager.instance), serverPlayer);
            ModMessages.sendToClientPlayer(new SyncBonusesPacket(BonusManager.instance), serverPlayer);
        }
    }

    @SubscribeEvent
    public static void addReqDisplay(ItemTooltipEvent event) {
        ClientHelper.addReqContent(event.getToolTip()::add, RegistryReqType.ITEM, event.getItemStack().m_41720_(), (LivingEntity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void healingDisplay(LivingHealEvent event) {
        if (event.getAmount() > 0.0f) {
            MiscHelper.createDamageIndicator(event.getEntity(), event.getAmount(), "heal", false);
        }
    }

    @SubscribeEvent
    public static void modArrowEnchantments(ArrowLooseEvent event) {
        event.setCharge((int)((double)event.getCharge() * event.getEntity().m_21133_((Attribute)ExtraAttributes.DRAW_SPEED.get()) / 100.0));
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            Level level = (Level)event.getLevel();
            arrowHelper.remove(level.m_46472_());
        }
    }

    @SubscribeEvent
    public static void joinLevelEvent(EntityJoinLevelEvent event) {
        Entity living;
        Entity entity;
        AbstractArrow arrow;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractArrow && !(arrow = (AbstractArrow)entity2).m_9236_().m_5776_() && (entity = arrow.m_19749_()) instanceof LivingEntity) {
            living = (LivingEntity)entity;
            ItemStack bow = living.m_21205_();
            CompoundTag arrowTag = arrow.getPersistentData();
            if (bow.m_204117_(ExtraTags.Items.HITS_ENDERMAN)) {
                arrowTag.m_128379_("HitsEnderMan", true);
            }
            for (Enchantment enchantment : bow.getAllEnchantments().keySet()) {
                if (!(enchantment instanceof ModBowEnchantment)) continue;
                ModBowEnchantment bowEnchantment = (ModBowEnchantment)enchantment;
                if (!RequirementManager.instance.meetsRequirements(RequirementType.ENCHANTMENT, enchantment, (LivingEntity)living)) continue;
                CompoundTag tag = new CompoundTag();
                int level = bow.getEnchantmentLevel(enchantment);
                tag.m_128405_("Level", level);
                arrowTag.m_128365_(Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment), "unknown enchantment: " + enchantment).toString(), (Tag)bowEnchantment.write(tag, level, bow, (LivingEntity)living, arrow));
                if (!bowEnchantment.shouldTick()) continue;
                arrowHelper.get(arrow.m_9236_().m_46472_()).add(arrow.m_20148_());
            }
        }
        if ((living = event.getEntity()) instanceof Player) {
            Player player = (Player)living;
            AttributeInstance manaInst = player.m_21051_((Attribute)ExtraAttributes.MANA.get());
            CompoundTag tag = player.getPersistentData();
            if (manaInst == null) {
                throw new IllegalStateException();
            }
            if (tag.m_128425_("Health", 5)) {
                player.m_21153_(tag.m_128457_("Health"));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)player;
                Wearables.send(sP);
                Cooldowns.send(sP);
            }
        }
    }

    @SubscribeEvent
    public static void leaveLevelEvent(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getPersistentData().m_128347_("Mana", player.m_21133_((Attribute)ExtraAttributes.MANA.get()));
        }
        if (event.getEntity().m_9236_().m_5776_()) {
            ((EntityRemovedTerminatorTrigger)TerminatorTriggers.ENTITY_REMOVED.get()).trigger(event.getEntity().m_19879_());
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            arrowHelper.putIfAbsent((ResourceKey<Level>)serverLevel.m_46472_(), Queue.create());
            Queue<UUID> queue = arrowHelper.get(serverLevel.m_46472_());
            queue.queue(uuid -> {
                Arrow arrow = (Arrow)serverLevel.m_8791_(uuid);
                if (arrow != null) {
                    CompoundTag arrowTag = arrow.getPersistentData();
                    ModBowEnchantment.loadFromTag(null, arrowTag, ModBowEnchantment.ExePhase.TICK, 0.0f, (AbstractArrow)arrow);
                } else {
                    queue.remove((UUID)uuid);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void healthRegenRegister(LivingHealEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_21051_((Attribute)ExtraAttributes.VITALITY.get()) != null) {
            double vitality = living.m_21133_((Attribute)ExtraAttributes.VITALITY.get());
            event.setAmount(event.getAmount() * (1.0f + (float)vitality / 100.0f));
        }
    }

    @SubscribeEvent
    public static void onGameShuttingDown(GameShuttingDownEvent event) {
        PlayerHeadAllocator.getInstance().shutDown();
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        Mob mob;
        LivingEntity living = event.getEntity();
        if (living.m_21224_() || living.m_213877_()) {
            return;
        }
        Cooldowns.get(living).tick();
        BonusHelper.tickEnchantments(living);
        CompoundTag tag = living.getPersistentData();
        if (living instanceof Player) {
            Player player = (Player)living;
            if (!player.m_20096_()) {
                if (Events.canJump(player) && (double)tag.m_128451_(DOUBLE_JUMP_ID) < player.m_21133_((Attribute)ExtraAttributes.DOUBLE_JUMP.get()) && player.f_20899_ && player.f_20954_ <= 0) {
                    ParticleHelper.sendAlwaysVisibleParticles((ParticleOptions)ParticleTypes.f_123796_, player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.25, 0.0, 0.25, 0.0, 0.0, 0.0, 15);
                    player.f_20954_ = 10;
                    player.f_19789_ = 0.0f;
                    Vec3 targetLoc = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82490_(0.75).m_82520_(0.0, 1.0, 0.0);
                    player.m_20334_(targetLoc.f_82479_, targetLoc.f_82480_ > 0.0 ? targetLoc.f_82480_ : -targetLoc.f_82480_, targetLoc.f_82481_);
                    IOHelper.increaseIntegerTagValue(player.getPersistentData(), DOUBLE_JUMP_ID, 1);
                }
            } else if (tag.m_128451_(DOUBLE_JUMP_ID) > 0) {
                tag.m_128405_(DOUBLE_JUMP_ID, 0);
            }
        }
        if (living instanceof Mob && (mob = (Mob)living).m_5448_() != null && mob.m_5448_().m_20145_()) {
            mob.m_6710_(null);
        }
    }

    private static boolean canJump(Player player) {
        return !player.m_20096_() && !player.m_20159_() && !player.m_150110_().f_35935_ && !player.m_20069_() && !player.m_20077_();
    }

    @SubscribeEvent
    public static void addWearableToPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            event.addCapability(KapLibMod.res("wearable"), (ICapabilityProvider)new WearableProvider(living));
            event.addCapability(KapLibMod.res("cooldowns"), (ICapabilityProvider)new CooldownsProvider(living));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        event.setExpToDrop((int)((double)event.getExpToDrop() * AttributeHelper.getExperienceScale(player)));
    }

    @SubscribeEvent
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * AttributeHelper.getExperienceScale(player)));
        }
    }
}

