/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.helpers.CollectorHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.util.Reference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MathHelper {
    public static final double DAMAGE_CALCULATION_VALUE = 50.0;

    public static int ARGBtoInt(int a, int r, int g, int b) {
        int returnable = (a << 8) + r;
        returnable = (returnable << 8) + g;
        return (returnable << 8) + b;
    }

    public static int RGBAtoInt(int r, int g, int b, int a) {
        return ((r & 0xFF) << 8 | (g & 0xFF) << 8 | b & 0xFF) << 8 | a & 0xFF;
    }

    public static IntSet intSetRange(int min, int max) {
        int[] range = new int[max - min + 1];
        for (int i = min; i <= max; ++i) {
            range[i - min] = min + i;
        }
        return IntSet.of((int[])range);
    }

    public static Vec2 normal(Vec2 og) {
        return new Vec2(og.f_82470_, -og.f_82471_);
    }

    public static double round(double no, int num) {
        return Math.floor(no * Math.pow(10.0, num)) / Math.pow(10.0, num);
    }

    public static double defRound(double no) {
        return MathHelper.round(no, 2);
    }

    public static double shortRound(double no) {
        return MathHelper.round(no, 1);
    }

    public static float calculateDamage(float damage, double armorValue, double armorToughnessValue) {
        double f = 50.0 - armorToughnessValue / 4.0;
        double defencePercentage = armorValue / (armorValue + f);
        return (float)((double)damage * (1.0 - defencePercentage));
    }

    public static Vec3 getHandHoldingItemAngle(HumanoidArm arm, @NotNull Entity entity) {
        return entity.m_20182_().m_82549_(entity.m_20171_(0.0f, entity.m_146908_() + (float)(arm == HumanoidArm.RIGHT ? 80 : -80)).m_82490_(0.5));
    }

    public static Vec3 rotateXAxis(@NotNull Vec3 source, Vec3 pivot, float angle) {
        double y = (source.f_82480_ - pivot.f_82480_) * (double)Mth.m_14089_((float)angle) - (source.f_82481_ - pivot.f_82481_) * (double)Mth.m_14031_((float)angle) + pivot.f_82480_;
        double z = (source.f_82480_ - pivot.f_82480_) * (double)Mth.m_14031_((float)angle) + (source.f_82481_ - pivot.f_82481_) * (double)Mth.m_14089_((float)angle) + pivot.f_82481_;
        return new Vec3(source.f_82479_, y, z);
    }

    public static Vec3 rotateHorizontalYAxis(@NotNull Vec3 source, @NotNull Vec3 pivot, float angle) {
        double x = (source.f_82479_ - pivot.f_82479_) * (double)Mth.m_14089_((float)angle) - (source.f_82481_ - pivot.f_82481_) * (double)Mth.m_14031_((float)angle) + pivot.f_82479_;
        double z = (source.f_82479_ - pivot.f_82479_) * (double)Mth.m_14031_((float)angle) + (source.f_82481_ - pivot.f_82481_) * (double)Mth.m_14089_((float)angle) + pivot.f_82481_;
        return new Vec3(x, source.f_82480_, z);
    }

    public static Vec3 rotateZAxis(@NotNull Vec3 source, @NotNull Vec3 pivot, float angle) {
        double x = (source.f_82479_ - pivot.f_82479_) * (double)Mth.m_14089_((float)angle) - (source.f_82480_ - pivot.f_82480_) * (double)Mth.m_14031_((float)angle) + pivot.f_82479_;
        double y = (source.f_82479_ - pivot.f_82479_) * (double)Mth.m_14031_((float)angle) + (source.f_82480_ - pivot.f_82480_) * (double)Mth.m_14089_((float)angle) + pivot.f_82480_;
        return new Vec3(x, y, source.f_82481_);
    }

    public static Vec3 rotateAroundAxis(@NotNull Vec3 source, @NotNull Vec3 pivot, float angle, @NotNull Direction.Axis axis) {
        angle *= (float)Math.PI / 180;
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> MathHelper.rotateXAxis(source, pivot, angle);
            case Direction.Axis.Y -> MathHelper.rotateHorizontalYAxis(source, pivot, angle);
            case Direction.Axis.Z -> MathHelper.rotateZAxis(source, pivot, angle);
        };
    }

    public static boolean isBetween(double val, int start, int end) {
        return Mth.m_14008_((double)val, (double)start, (double)end) == val;
    }

    public static boolean isBetween(double val, double start, double end) {
        return Mth.m_14008_((double)val, (double)start, (double)end) == val;
    }

    public static boolean is2dBetween(double xVal, double yVal, int xStart, int yStart, int xEnd, int yEnd) {
        return MathHelper.isBetween(xVal, xStart, xEnd) && MathHelper.isBetween(yVal, yStart, yEnd);
    }

    public static int getLargest(@NotNull Collection<Integer> floats) {
        return floats.stream().mapToInt(i -> i).max().orElse(0);
    }

    @Contract(value="_, _ -> new")
    public static Predicate<String> checkForInteger(int min, int max) {
        return s -> {
            try {
                int num = Integer.parseInt(s);
                return num >= min && num <= max;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    public static <T extends Entity> List<T> getEntitiesAround(Class<T> tClass, Entity source, double range) {
        Level level = source.m_9236_();
        return MathHelper.getEntitiesAround(tClass, level, source.m_20191_(), range);
    }

    @Contract(value="_, null, _ -> fail; null, _, _ -> fail")
    public static void add(Supplier<Integer> getter, Consumer<Integer> setter, int change) {
        setter.accept(getter.get() + change);
    }

    public static void up1(Reference<Integer> reference) {
        MathHelper.add(reference::getIntValue, reference::setValue, 1);
    }

    public static void mul(Supplier<Integer> getter, Consumer<Integer> setter, int mul) {
        setter.accept(getter.get() * mul);
    }

    public static void mul(Supplier<Double> getter, Consumer<Double> setter, double mul) {
        setter.accept(getter.get() * mul);
    }

    public static void mul(Supplier<Float> getter, Consumer<Float> setter, float mul) {
        setter.accept(Float.valueOf(getter.get().floatValue() * mul));
    }

    @Contract(value="null, _, _ -> fail; _, _, _ -> new")
    public static ArrayList<Vec3> lineOfSight(Entity entity, double range, double scaling) {
        Vec3 viewVec = entity.m_20171_(entity.m_146909_(), entity.m_146908_());
        Vec3 viewVecWithLoc = viewVec.m_82549_(entity.m_146892_());
        Vec3 end = viewVec.m_82490_(range).m_82549_(entity.m_146892_());
        BlockHitResult result = entity.m_9236_().m_45547_(new ClipContext(viewVecWithLoc, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        Vec3 diff = result.m_82450_().m_82546_(viewVecWithLoc);
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        int i = 0;
        while ((double)i < diff.m_82553_() / scaling) {
            list.add(MathHelper.clampLength(diff, (double)i * scaling).m_82549_(entity.m_146892_()));
            ++i;
        }
        return list;
    }

    public static ArrayList<Vec3> lineOfSight(Vec2 vec, Vec3 pos, double range, double scaling) {
        ArrayList<Vec3> line = new ArrayList<Vec3>();
        for (double i = 0.0; i <= range; i += scaling) {
            Vec3 vec3 = MathHelper.calculateViewVector(vec.f_82470_, vec.f_82471_).m_82490_(i).m_82520_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            line.add(vec3);
        }
        return line;
    }

    public static int count(@NotNull Collection<Integer> collection) {
        int count = 0;
        for (Integer integer : collection) {
            count += integer.intValue();
        }
        return count;
    }

    public static List<BlockPos> makeLine(BlockPos a, BlockPos b, LineSize size) {
        BlockPos diff = b.m_121996_((Vec3i)a);
        double horizontal = Mth.m_14116_((float)(diff.m_123341_() * diff.m_123341_() + diff.m_123343_() * diff.m_123343_() + diff.m_123342_() * diff.m_123342_()));
        int numPoints = (int)(size == LineSize.THIN ? horizontal * 20.0 : horizontal * 50.0);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        MiscHelper.repeat(numPoints, integer -> {
            double t = (double)integer.intValue() / ((double)numPoints - 1.0);
            list.add(MathHelper.makeLinePos(t, a, diff));
        });
        return list;
    }

    private static BlockPos makeLinePos(double t, BlockPos a, BlockPos diff) {
        return new BlockPos((int)((double)a.m_123341_() + (double)diff.m_123341_() * t), (int)((double)a.m_123342_() + (double)diff.m_123342_() * t), (int)((double)a.m_123343_() + (double)diff.m_123343_() * t));
    }

    public static List<Vec3> makeLine(Vec3 a, Vec3 b, float spacing) {
        Vec3 diff = b.m_82546_(a);
        int numPoints = (int)(diff.m_82553_() / (double)spacing);
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        MiscHelper.repeat(numPoints, integer -> {
            double t = (double)integer.intValue() / ((double)numPoints - 1.0);
            list.add(a.m_82549_(diff.m_82490_(t)));
        });
        return list;
    }

    public static <T> boolean validIndex(List<T> values, int selectedIndex) {
        return MathHelper.isBetween((double)selectedIndex, 0, values.size() - 1);
    }

    public static Vec3 withRoll(Vec2 rotation, float roll) {
        return new Vec3((double)rotation.f_82470_, (double)rotation.f_82471_, (double)roll);
    }

    public static Vec3 moveTowards(Vec3 source, Vec3 target, double range, boolean percentage) {
        Vec3 change = source.m_82546_(target);
        double dist = source.m_82554_(target);
        return percentage ? MathHelper.clampLength(change, dist * range) : MathHelper.clampLength(change, range);
    }

    @Nullable
    public static <T> T pickRandom(@NotNull List<T> list) {
        return MathHelper.pickRandom(list, KapLibMod.RANDOM_SOURCE);
    }

    public static <T> T pickRandom(@NotNull List<T> list, @NotNull RandomSource source) {
        return list.isEmpty() ? null : (T)list.get(Mth.m_216271_((RandomSource)source, (int)0, (int)(list.size() - 1)));
    }

    public static boolean chance(double baseChance, @Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return MathHelper.chance(baseChance, living);
        }
        return MathHelper.chance(baseChance, null);
    }

    public static boolean chance(double chance, @Nullable LivingEntity living) {
        return Math.random() <= chance * (living != null ? 1.0 + living.m_21133_(Attributes.f_22286_) / 100.0 : 1.0);
    }

    public static int cooldown(LivingEntity living, int defaultTime) {
        return (int)((double)defaultTime * (1.0 - living.m_21133_((Attribute)ExtraAttributes.COOLDOWN_REDUCTION.get()) / 100.0));
    }

    public static <T extends Entity> List<T> getEntitiesAround(Class<T> tClass, Level level, AABB source, double range) {
        return level.m_45976_(tClass, source.m_82400_(range));
    }

    @Nullable
    public static <T extends Entity> T getClosestEntity(Class<T> tClass, Entity source, double range) {
        List<Entity> entities = MathHelper.getEntitiesAround(tClass, source, range).stream().filter(t -> t.m_7306_(source)).sorted(Comparator.comparingDouble(value -> value.m_20270_(source))).toList();
        if (entities.isEmpty()) {
            return null;
        }
        return (T)entities.get(0);
    }

    public static LivingEntity getClosestLiving(Entity source, double range) {
        return MathHelper.getClosestEntity(LivingEntity.class, source, range);
    }

    public static List<LivingEntity> getLivingAround(Entity source, double range) {
        return MathHelper.getEntitiesAround(LivingEntity.class, source, range);
    }

    public static Vec3 calculateViewVector(float horizontalHeightXAxis, float verticalYAxis) {
        float f = horizontalHeightXAxis * ((float)Math.PI / 180);
        float f1 = -verticalYAxis * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static <T extends Entity> List<T> getAllEntitiesInsideCone(Class<T> tClass, float span, double range, Vec3 sourcePos, Vec2 sourceRot, Level level) {
        double halfSpan = span / 2.0f;
        double incremental = Math.sin(halfSpan) * 0.1;
        ArrayList<Vec3> lineOfSight = MathHelper.lineOfSight(sourceRot, sourcePos, range, 0.1);
        ArrayList toReturn = new ArrayList();
        lineOfSight.stream().collect(CollectorHelper.createMapForKeys(lineOfSight::indexOf)).forEach((integer, vec3) -> toReturn.addAll(MathHelper.getEntitiesAround(tClass, level, vec3, incremental * (double)integer.intValue()).stream().filter(entity -> !toReturn.contains(entity)).toList()));
        return toReturn;
    }

    public static <T extends Entity> List<T> getEntitiesAround(Class<T> tClass, Level level, Vec3 loc, double range) {
        return level.m_45976_(tClass, new AABB(loc.f_82479_ - range, loc.f_82480_ - range, loc.f_82481_ - range, loc.f_82479_ + range, loc.f_82480_ + range, loc.f_82481_ + range));
    }

    public static List<Entity> getAllEntitiesInsideCylinder(float radius, Vec3 sourcePos, Vec2 rot, double range, Level level) {
        ArrayList<Entity> toReturn = new ArrayList<Entity>();
        ArrayList<Vec3> lineOfSight = MathHelper.lineOfSight(rot, sourcePos, range, 0.1);
        lineOfSight.forEach(vec3 -> {
            List<Entity> entities = MathHelper.getEntitiesAround(Entity.class, level, vec3, (double)radius);
            toReturn.addAll(entities.stream().filter(entity -> !toReturn.contains(entity)).toList());
        });
        return toReturn;
    }

    public static Vec2 createTargetRotation(Entity source, Entity target) {
        return MathHelper.createTargetRotationFromPos(source.m_20182_(), target.m_20182_());
    }

    public static Vec2 createTargetRotationFromPos(@NotNull Vec3 source, @NotNull Vec3 target) {
        double dX = target.f_82479_ - source.f_82479_;
        double dY = target.f_82480_ - source.f_82480_;
        double dZ = target.f_82481_ - source.f_82481_;
        double d3 = Math.sqrt(dX * dX + dZ * dZ);
        return new Vec2(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)dY, (double)d3) * 57.2957763671875)))), Mth.m_14177_((float)((float)(Mth.m_14136_((double)dZ, (double)dX) * 57.2957763671875) - 90.0f)));
    }

    public static Vec2 createTargetRotationFromEyeHeight(Entity source, Entity target) {
        return MathHelper.createTargetRotationFromPos(source.m_146892_(), target.m_146892_());
    }

    public static boolean isBehind(Entity source, Entity target) {
        Vec3 vec32 = source.m_20182_();
        Vec3 vec31 = vec32.m_82505_(target.m_20182_()).m_82541_();
        vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
        return !(vec31.m_82526_(target.m_20252_(1.0f)) < 0.0);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 minimiseLength(Vec3 source, double minimum) {
        if (source.m_82553_() > minimum) {
            return source;
        }
        double scale = minimum / source.m_82553_();
        return source.m_82490_(scale);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 maximiseLength(Vec3 source, double maximum) {
        if (source.m_82553_() < maximum) {
            return source;
        }
        double scale = maximum / source.m_82553_();
        return source.m_82490_(scale);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 clampLength(Vec3 source, double value) {
        if (source.m_82553_() > value) {
            return MathHelper.maximiseLength(source, value);
        }
        return MathHelper.minimiseLength(source, value);
    }

    public static Vec3 getRandomOffsetForPos(Entity target, double dist, double maxOffset) {
        RandomSource source = RandomSource.m_216327_();
        Vec2 rot = target.m_20155_();
        Vec3 targetPos = MathHelper.calculateViewVector(rot.f_82470_, rot.f_82471_).m_82490_(dist);
        Vec3 secPos = MathHelper.removeByScale(MathHelper.calculateViewVector(rot.f_82470_ - 90.0f, rot.f_82471_).m_82490_((maxOffset *= 2.0) * (double)source.m_188501_()), 0.5);
        Vec3 thirdPos = MathHelper.removeByScale(MathHelper.calculateViewVector(rot.f_82470_, rot.f_82471_ - 90.0f).m_82490_(maxOffset * (double)source.m_188501_()), 0.5);
        return targetPos.m_82549_(secPos).m_82549_(thirdPos);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 removeByScale(Vec3 vec3, double scale) {
        double x = vec3.f_82479_;
        double y = vec3.f_82480_;
        double z = vec3.f_82481_;
        double halfX = x - x * scale;
        double halfY = y - y * scale;
        double halfZ = z - z * scale;
        return new Vec3(halfX, halfY, halfZ);
    }

    public static float randomBetween(RandomSource source, float min, float max) {
        return Mth.m_14179_((float)source.m_188501_(), (float)min, (float)max);
    }

    public static double randomBetween(RandomSource source, double min, double max) {
        return Mth.m_14139_((double)source.m_188500_(), (double)min, (double)max);
    }

    public static Vec3 randomBetween(RandomSource source, Vec3 min, Vec3 max) {
        return new Vec3(MathHelper.randomBetween(source, min.f_82479_, max.f_82479_), MathHelper.randomBetween(source, min.f_82480_, max.f_82480_), MathHelper.randomBetween(source, min.f_82481_, max.f_82481_));
    }

    public static Vec3 randomIn(RandomSource source, AABB box) {
        return new Vec3(MathHelper.randomBetween(source, box.f_82288_, box.f_82291_), MathHelper.randomBetween(source, box.f_82289_, box.f_82292_), MathHelper.randomBetween(source, box.f_82290_, box.f_82293_));
    }

    public static float getOversizeScale(Vec3 original, Vec3 clamped) {
        return MathHelper.pickLargest((float)(clamped.f_82479_ / original.f_82479_), (float)(clamped.f_82480_ / original.f_82480_), (float)(clamped.f_82481_ / original.f_82481_));
    }

    public static float pickLargest(float ... values) {
        Float min = null;
        for (float f : values) {
            if (min != null && !(min.floatValue() < f)) continue;
            min = Float.valueOf(f);
        }
        return min == null ? -1.0f : min.floatValue();
    }

    public static BlockPos randomOffset(BlockPos pivot, RandomSource source) {
        int random = source.m_216332_(0, 8);
        if (random > 2) {
            ++random;
        }
        int xOffset = random / 3 - 1;
        int zOffset = random % 3 - 1;
        return pivot.m_7918_(xOffset, 0, zOffset);
    }

    public static enum LineSize {
        THIN,
        THICK;

    }
}

