/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.page_renderer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.kapitencraft.kap_lib.event.custom.client.RegisterInventoryPageRenderersEvent;
import net.kapitencraft.kap_lib.inventory.page.InventoryPage;
import net.kapitencraft.kap_lib.inventory.page.InventoryPageType;
import net.kapitencraft.kap_lib.inventory.page.crafting.CraftingPageRenderer;
import net.kapitencraft.kap_lib.inventory.page.equipment.EquipmentPageRenderer;
import net.kapitencraft.kap_lib.inventory.page_renderer.InventoryPageRenderer;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaInventoryPages;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class InventoryPageRenderers {
    private static final Map<InventoryPageType<?>, PageRenderConstructor<?>> renderers = new HashMap();

    public static <P extends InventoryPage> PageRenderConstructor<P> getRenderer(P page) {
        return Objects.requireNonNull(renderers.get(page.getType()), "no renderer for inventory page: '" + ExtraRegistries.INVENTORY_PAGES.getKey(page.getType()) + "'");
    }

    public static void init() {
        InventoryPageRenderers.register((InventoryPageType)VanillaInventoryPages.EQUIPMENT.get(), EquipmentPageRenderer::new);
        InventoryPageRenderers.register((InventoryPageType)VanillaInventoryPages.CRAFTING.get(), CraftingPageRenderer::new);
        ModLoader.get().postEvent((Event)new RegisterInventoryPageRenderersEvent());
    }

    @ApiStatus.Internal
    public static <P extends InventoryPage> void register(InventoryPageType<P> type, PageRenderConstructor<P> renderer) {
        if (renderers.put(type, renderer) != null) {
            throw new IllegalArgumentException("duplicate inventory page renderer registration: " + ExtraRegistries.INVENTORY_PAGES.getKey(type));
        }
    }

    public static interface PageRenderConstructor<P extends InventoryPage> {
        public InventoryPageRenderer construct(P var1);
    }
}

