/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.wearable;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.inventory.wearable.Wearables;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public interface IWearable {
    default public Multimap<Attribute, AttributeModifier> getModifiers(WearableSlot slot, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public WearableSlot getSlot();

    default public InteractionResultHolder<ItemStack> swapWithEquipmentSlot(Item pItem, Level pLevel, Player pPlayer, InteractionHand pHand) {
        WearableSlot wearableSlot;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (pItem instanceof IWearable) {
            IWearable wearable = (IWearable)pItem;
            wearableSlot = wearable.getSlot();
        } else {
            wearableSlot = null;
        }
        WearableSlot slot = Objects.requireNonNull(wearableSlot, "item not wearable: " + ForgeRegistries.ITEMS.getKey((Object)pItem));
        Wearables wearables = Wearables.get((LivingEntity)pPlayer);
        ItemStack original = wearables.get(slot);
        if (!EnchantmentHelper.m_44920_((ItemStack)original) && !ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)original)) {
            if (!pLevel.m_5776_()) {
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)pItem));
            }
            ItemStack stack = original.m_41619_() ? itemstack : original.m_278832_();
            ItemStack stack1 = itemstack.m_278832_();
            wearables.m_6836_(slot.getSlotIndex(), stack1);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }
}

