/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import net.kapitencraft.kap_lib.io.JsonHelper;
import org.slf4j.Logger;

public class ModrinthUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROJECT_URL = "https://api.modrinth.com/v2/project/";

    public static Stream<JsonObject> readVersions(String projectId, String gameVersion, String agentName) throws IOException {
        String projectVersionURL = PROJECT_URL + projectId + "/version";
        String requestParams = "?loaders=" + URLEncoder.encode(JsonHelper.GSON.toJson((Object)new String[]{"forge"}), StandardCharsets.UTF_8) + "&game_versions=" + URLEncoder.encode(JsonHelper.GSON.toJson((Object)new Object[]{gameVersion}), StandardCharsets.UTF_8);
        URL url = new URL(projectVersionURL + requestParams);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", agentName + " for '" + projectId + "', (kapitencraft@gmail.com)");
        int response = connection.getResponseCode();
        if (response != 200) {
            return null;
        }
        InputStream dataStream = connection.getInputStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(dataStream));
        JsonArray data = (JsonArray)Streams.parse((JsonReader)reader);
        reader.close();
        return JsonHelper.castToObjects(data);
    }
}

