/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.registry.vanilla;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public interface VanillaComponentContentTypes {
    public static final DeferredRegister<Codec<? extends ComponentContents>> REGISTRY = DeferredRegister.create(ExtraRegistries.Keys.COMPONENT_CONTENTS_TYPES, (String)"minecraft");
    public static final RegistryObject<Codec<ComponentContents>> EMPTY = REGISTRY.register("empty", () -> Codec.unit((Object)ComponentContents.f_237124_));
    public static final RegistryObject<Codec<LiteralContents>> LITERAL = REGISTRY.register("literal", VanillaComponentContentTypes::createLiterals);
    public static final RegistryObject<Codec<KeybindContents>> KEY_BIND = REGISTRY.register("key_bind", VanillaComponentContentTypes::createKeybind);
    public static final RegistryObject<Codec<NbtContents>> NBT = REGISTRY.register("nbt", VanillaComponentContentTypes::createNBT);
    public static final RegistryObject<Codec<ScoreContents>> SCORE = REGISTRY.register("score", VanillaComponentContentTypes::createScore);
    public static final RegistryObject<Codec<SelectorContents>> SELECTOR = REGISTRY.register("selector", VanillaComponentContentTypes::createSelector);
    public static final RegistryObject<Codec<TranslatableContents>> TRANSLATABLE = REGISTRY.register("translatable", VanillaComponentContentTypes::createTranslatable);

    private static Codec<LiteralContents> createLiterals() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("text").forGetter(LiteralContents::f_237368_)).apply((Applicative)instance, LiteralContents::new));
    }

    private static Codec<KeybindContents> createKeybind() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("keybind").forGetter(KeybindContents::m_237348_)).apply((Applicative)instance, KeybindContents::new));
    }

    private static Codec<NbtContents> createNBT() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::m_237399_), (App)Codec.BOOL.fieldOf("interpret").forGetter(NbtContents::m_237426_), (App)ExtraCodecs.COMPONENT.optionalFieldOf("separator").forGetter(NbtContents::m_237427_), (App)ExtraCodecs.DATA_SOURCE.fieldOf("data_source").forGetter(NbtContents::m_237428_)).apply((Applicative)instance, NbtContents::new));
    }

    private static Codec<ScoreContents> createScore() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ScoreContents::m_237440_), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreContents::m_237453_)).apply((Applicative)instance, ScoreContents::new));
    }

    private static Codec<SelectorContents> createSelector() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("selector").forGetter(SelectorContents::m_237466_), (App)ExtraCodecs.COMPONENT.optionalFieldOf("separator").forGetter(SelectorContents::m_237479_)).apply((Applicative)instance, SelectorContents::new));
    }

    private static Codec<TranslatableContents> createTranslatable() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translate").forGetter(TranslatableContents::m_237508_), (App)Codec.STRING.optionalFieldOf("fallback").forGetter(c -> Optional.ofNullable(c.m_264577_())), (App)ExtraCodecs.TRANSLATABLE_COMPONENT_ARGS.optionalFieldOf("with", (Object)TranslatableContents.f_237494_).forGetter(TranslatableContents::m_237523_)).apply((Applicative)instance, (string, s, objects) -> new TranslatableContents(string, (String)s.orElse(null), objects)));
    }
}

