/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnPoolEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.core.FunctionUserBuilder;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnPool {
    final SpawnPoolEntryContainer[] entries;
    final LootItemCondition[] conditions;
    private final Predicate<LootContext> compositeCondition;
    final SpawnEntityFunction[] functions;
    private final BiFunction<Entity, SpawnContext, Entity> compositeFunction;
    NumberProvider rolls;
    NumberProvider bonusRolls;
    private boolean isFrozen = false;
    @Nullable
    private final String name;

    SpawnPool(SpawnPoolEntryContainer[] pEntries, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions, NumberProvider pRolls, NumberProvider pBonusRolls, @Nullable String name) {
        this.name = name;
        this.entries = pEntries;
        this.conditions = pConditions;
        this.compositeCondition = LootItemConditions.m_81834_((Predicate[])pConditions);
        this.functions = pFunctions;
        this.compositeFunction = SpawnEntityFunctions.compose(pFunctions);
        this.rolls = pRolls;
        this.bonusRolls = pBonusRolls;
    }

    private void addRandomEntity(Consumer<Entity> pEntityConsumer, SpawnContext pContext) {
        RandomSource randomsource = pContext.m_230907_();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        for (SpawnPoolEntryContainer entryContainer : this.entries) {
            entryContainer.expand(pContext, p_79048_ -> {
                int k = p_79048_.getWeight(pContext.m_78945_());
                if (k > 0) {
                    list.add(p_79048_);
                    mutableint.add(k);
                }
            });
        }
        int i = list.size();
        if (mutableint.intValue() != 0 && i != 0) {
            if (i == 1) {
                ((SpawnPoolEntry)list.get(0)).createEntity(pEntityConsumer, pContext);
            } else {
                int j = randomsource.m_188503_(mutableint.intValue());
                for (SpawnPoolEntry entry : list) {
                    if ((j -= entry.getWeight(pContext.m_78945_())) >= 0) continue;
                    entry.createEntity(pEntityConsumer, pContext);
                    return;
                }
            }
        }
    }

    public void addRandomEntities(Consumer<Entity> pStackConsumer, SpawnContext pLootContext) {
        if (this.compositeCondition.test(pLootContext)) {
            Consumer<Entity> consumer = SpawnEntityFunction.decorate(this.compositeFunction, pStackConsumer, pLootContext);
            int i = this.rolls.m_142683_((LootContext)pLootContext) + Mth.m_14143_((float)(this.bonusRolls.m_142688_((LootContext)pLootContext) * pLootContext.m_78945_()));
            for (int j = 0; j < i; ++j) {
                this.addRandomEntity(consumer.andThen(arg_0 -> ((ServerLevel)pLootContext.m_78952_()).m_7967_(arg_0)), pLootContext);
            }
        }
    }

    public void validate(ValidationContext pContext) {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i].m_6169_(pContext.m_79365_(".condition[" + i + "]"));
        }
        for (int j = 0; j < this.functions.length; ++j) {
            this.functions[j].m_6169_(pContext.m_79365_(".functions[" + j + "]"));
        }
        for (int k = 0; k < this.entries.length; ++k) {
            this.entries[k].validate(pContext.m_79365_(".entries[" + k + "]"));
        }
        this.rolls.m_6169_(pContext.m_79365_(".rolls"));
        this.bonusRolls.m_6169_(pContext.m_79365_(".bonusRolls"));
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootPool after being frozen!");
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public NumberProvider getRolls() {
        return this.rolls;
    }

    public NumberProvider getBonusRolls() {
        return this.bonusRolls;
    }

    public void setRolls(NumberProvider v) {
        this.checkFrozen();
        this.rolls = v;
    }

    public void setBonusRolls(NumberProvider v) {
        this.checkFrozen();
        this.bonusRolls = v;
    }

    public static Builder spawnPool(String name) {
        return new Builder(name);
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final List<SpawnPoolEntryContainer> entries = Lists.newArrayList();
        private final List<LootItemCondition> conditions = Lists.newArrayList();
        private final List<SpawnEntityFunction> functions = Lists.newArrayList();
        private NumberProvider rolls = ConstantValue.m_165692_((float)1.0f);
        private NumberProvider bonusRolls = ConstantValue.m_165692_((float)0.0f);
        private final String name;

        public Builder(String name) {
            this.name = name;
        }

        public Builder setRolls(NumberProvider pRolls) {
            this.rolls = pRolls;
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public Builder setBonusRolls(NumberProvider pBonusRolls) {
            this.bonusRolls = pBonusRolls;
            return this;
        }

        public Builder add(SpawnPoolEntryContainer.Builder<?> pEntriesBuilder) {
            this.entries.add(pEntriesBuilder.build());
            return this;
        }

        public @NotNull Builder when(LootItemCondition.Builder pConditionBuilder) {
            this.conditions.add(pConditionBuilder.m_6409_());
            return this;
        }

        @Override
        public Builder apply(SpawnEntityFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder.build());
            return this;
        }

        public SpawnPool build() {
            if (this.rolls == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new SpawnPool(this.entries.toArray(new SpawnPoolEntryContainer[0]), this.conditions.toArray(new LootItemCondition[0]), this.functions.toArray(new SpawnEntityFunction[0]), this.rolls, this.bonusRolls, this.name);
        }
    }

    public static class Serializer
    implements JsonDeserializer<SpawnPool>,
    JsonSerializer<SpawnPool> {
        public SpawnPool deserialize(JsonElement pJson, Type pTypeOfT, JsonDeserializationContext pContext) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"loot pool");
            SpawnPoolEntryContainer[] containers = (SpawnPoolEntryContainer[])GsonHelper.m_13836_((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)pContext, SpawnPoolEntryContainer[].class);
            LootItemCondition[] alootitemcondition = (LootItemCondition[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"conditions", (Object)new LootItemCondition[0], (JsonDeserializationContext)pContext, LootItemCondition[].class);
            SpawnEntityFunction[] functions = (SpawnEntityFunction[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"functions", (Object)new SpawnEntityFunction[0], (JsonDeserializationContext)pContext, SpawnEntityFunction[].class);
            NumberProvider rolls = (NumberProvider)GsonHelper.m_13836_((JsonObject)jsonobject, (String)"rolls", (JsonDeserializationContext)pContext, NumberProvider.class);
            NumberProvider bonusRolls = (NumberProvider)GsonHelper.m_13845_((JsonObject)jsonobject, (String)"bonus_rolls", (Object)ConstantValue.m_165692_((float)0.0f), (JsonDeserializationContext)pContext, NumberProvider.class);
            return new SpawnPool(containers, alootitemcondition, functions, rolls, bonusRolls, GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name"));
        }

        public JsonElement serialize(SpawnPool pSrc, Type pTypeOfSrc, JsonSerializationContext pContext) {
            JsonObject jsonobject = new JsonObject();
            if (pSrc.name != null && !pSrc.name.startsWith("custom#")) {
                jsonobject.add("name", pContext.serialize((Object)pSrc.name));
            }
            jsonobject.add("rolls", pContext.serialize((Object)pSrc.rolls));
            jsonobject.add("bonus_rolls", pContext.serialize((Object)pSrc.bonusRolls));
            jsonobject.add("entries", pContext.serialize((Object)pSrc.entries));
            if (!ArrayUtils.isEmpty((Object[])pSrc.conditions)) {
                jsonobject.add("conditions", pContext.serialize((Object)pSrc.conditions));
            }
            if (!ArrayUtils.isEmpty((Object[])pSrc.functions)) {
                jsonobject.add("functions", pContext.serialize((Object)pSrc.functions));
            }
            return jsonobject;
        }
    }
}

