/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Optional;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class SpawnTableManager
extends SimpleJsonResourceReloadListener {
    private Map<ResourceLocation, SpawnTable> spawnTables;
    public static SpawnTableManager instance;

    public SpawnTableManager() {
        super(JsonHelper.GSON, "spawn_tables");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        pObject.forEach((location, element) -> {
            Optional optional = (Optional)SpawnTable.CREATOR.apply(location, element, (Object)pResourceManager);
            optional.ifPresent(table -> map.put(location, table));
        });
        this.spawnTables = map.build();
    }

    public SpawnTable getSpawnTable(ResourceLocation name) {
        return this.spawnTables.get(name);
    }
}

