/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Optional;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();

    public static TriFunction<ResourceLocation, JsonElement, ResourceManager, Optional<SpawnTable>> getSpawnTableSerializer(Gson gson, String directory) {
        return (location, data, resourceManager) -> {
            try {
                Resource resource = resourceManager.m_213713_(location.m_247449_(directory + "/" + location.m_135815_() + ".json")).orElse(null);
                boolean custom = resource == null || !resource.m_247137_();
                return Optional.of(SpawnTableProvider.loadLootTable(gson, location, data, custom));
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse element {}:{}", (Object)directory, location, (Object)exception);
                return Optional.empty();
            }
        };
    }

    public static SpawnTable loadLootTable(Gson gson, ResourceLocation name, JsonElement data, boolean custom) {
        SpawnTable ret = (SpawnTable)gson.fromJson(data, SpawnTable.class);
        ret.setId(name);
        ret.freeze();
        return ret;
    }
}

