/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnPoolEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.ComposableEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class CompositeEntryBase
extends SpawnPoolEntryContainer {
    protected final SpawnPoolEntryContainer[] children;
    private final ComposableEntryContainer composedChildren;

    protected CompositeEntryBase(SpawnPoolEntryContainer[] pChildren, LootItemCondition[] pConditions) {
        super(pConditions);
        this.children = pChildren;
        this.composedChildren = this.compose(pChildren);
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        if (this.children.length == 0) {
            pValidationContext.m_79357_("Empty children list");
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].validate(pValidationContext.m_79365_(".entry[" + i + "]"));
        }
    }

    protected abstract ComposableEntryContainer compose(ComposableEntryContainer[] var1);

    @Override
    public final boolean expand(SpawnContext pLootContext, Consumer<SpawnPoolEntry> pEntryConsumer) {
        return this.canRun(pLootContext) && this.composedChildren.expand(pLootContext, pEntryConsumer);
    }

    public static <T extends CompositeEntryBase> SpawnPoolEntryContainer.Serializer<T> createSerializer(final CompositeEntryConstructor<T> pFactory) {
        return new SpawnPoolEntryContainer.Serializer<T>(){

            @Override
            public void serializeCustom(JsonObject p_79449_, T pContainer, JsonSerializationContext p_79451_) {
                p_79449_.add("children", p_79451_.serialize((Object)((CompositeEntryBase)pContainer).children));
            }

            @Override
            public T deserializeCustom(JsonObject p_79445_, JsonDeserializationContext p_79446_, LootItemCondition[] p_79447_) {
                SpawnPoolEntryContainer[] entryContainers = (SpawnPoolEntryContainer[])GsonHelper.m_13836_((JsonObject)p_79445_, (String)"children", (JsonDeserializationContext)p_79446_, SpawnPoolEntryContainer[].class);
                return pFactory.create(entryContainers, p_79447_);
            }
        };
    }

    @FunctionalInterface
    public static interface CompositeEntryConstructor<T extends CompositeEntryBase> {
        public T create(SpawnPoolEntryContainer[] var1, LootItemCondition[] var2);
    }
}

