/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnPoolEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.core.FunctionUserBuilder;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SpawnPoolSingletonContainer
extends SpawnPoolEntryContainer {
    public static final int DEFAULT_WEIGHT = 1;
    public static final int DEFAULT_QUALITY = 0;
    protected final int weight;
    protected final int quality;
    protected final SpawnEntityFunction[] functions;
    final BiFunction<Entity, SpawnContext, Entity> compositeFunction;
    private final SpawnPoolEntry entry = new EntryBase(){

        @Override
        public void createEntity(Consumer<Entity> entitySink, SpawnContext context) {
            SpawnPoolSingletonContainer.this.createEntity(SpawnEntityFunction.decorate(SpawnPoolSingletonContainer.this.compositeFunction, entitySink, context), context);
        }
    };

    protected SpawnPoolSingletonContainer(int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
        super(pConditions);
        this.weight = pWeight;
        this.quality = pQuality;
        this.functions = pFunctions;
        this.compositeFunction = SpawnEntityFunctions.compose(pFunctions);
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i].m_6169_(pValidationContext.m_79365_(".functions[" + i + "]"));
        }
    }

    protected abstract void createEntity(Consumer<Entity> var1, SpawnContext var2);

    @Override
    public boolean expand(SpawnContext pLootContext, Consumer<SpawnPoolEntry> pEntryConsumer) {
        if (this.canRun(pLootContext)) {
            pEntryConsumer.accept(this.entry);
            return true;
        }
        return false;
    }

    public static Builder<?> simpleBuilder(EntryConstructor pEntryBuilder) {
        return new DummyBuilder(pEntryBuilder);
    }

    static class DummyBuilder
    extends Builder<DummyBuilder> {
        private final EntryConstructor constructor;

        public DummyBuilder(EntryConstructor pConstructor) {
            this.constructor = pConstructor;
        }

        @Override
        protected DummyBuilder getThis() {
            return this;
        }

        @Override
        public SpawnPoolEntryContainer build() {
            return this.constructor.build(this.weight, this.quality, this.getConditions(), this.getFunctions());
        }
    }

    @FunctionalInterface
    protected static interface EntryConstructor {
        public SpawnPoolSingletonContainer build(int var1, int var2, LootItemCondition[] var3, SpawnEntityFunction[] var4);
    }

    public static abstract class Serializer<T extends SpawnPoolSingletonContainer>
    extends SpawnPoolEntryContainer.Serializer<T> {
        @Override
        public void serializeCustom(JsonObject pObject, T pContainer, JsonSerializationContext pConditions) {
            if (((SpawnPoolSingletonContainer)pContainer).weight != 1) {
                pObject.addProperty("weight", (Number)((SpawnPoolSingletonContainer)pContainer).weight);
            }
            if (((SpawnPoolSingletonContainer)pContainer).quality != 0) {
                pObject.addProperty("quality", (Number)((SpawnPoolSingletonContainer)pContainer).quality);
            }
            if (!ArrayUtils.isEmpty((Object[])((SpawnPoolSingletonContainer)pContainer).functions)) {
                pObject.add("functions", pConditions.serialize((Object)((SpawnPoolSingletonContainer)pContainer).functions));
            }
        }

        @Override
        public final T deserializeCustom(JsonObject pObject, JsonDeserializationContext pContext, LootItemCondition[] pConditions) {
            int i = GsonHelper.m_13824_((JsonObject)pObject, (String)"weight", (int)1);
            int j = GsonHelper.m_13824_((JsonObject)pObject, (String)"quality", (int)0);
            SpawnEntityFunction[] functions = (SpawnEntityFunction[])GsonHelper.m_13845_((JsonObject)pObject, (String)"functions", (Object)new SpawnEntityFunction[0], (JsonDeserializationContext)pContext, SpawnEntityFunction[].class);
            return this.deserialize(pObject, pContext, i, j, pConditions, functions);
        }

        protected abstract T deserialize(JsonObject var1, JsonDeserializationContext var2, int var3, int var4, LootItemCondition[] var5, SpawnEntityFunction[] var6);
    }

    protected abstract class EntryBase
    implements SpawnPoolEntry {
        protected EntryBase() {
        }

        @Override
        public int getWeight(float pLuck) {
            return Math.max(Mth.m_14143_((float)((float)SpawnPoolSingletonContainer.this.weight + (float)SpawnPoolSingletonContainer.this.quality * pLuck)), 0);
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends SpawnPoolEntryContainer.Builder<T>
    implements FunctionUserBuilder<T> {
        protected int weight = 1;
        protected int quality = 0;
        private final List<SpawnEntityFunction> functions = Lists.newArrayList();

        @Override
        public T apply(SpawnEntityFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder.build());
            return (T)((Builder)this.getThis());
        }

        protected SpawnEntityFunction[] getFunctions() {
            return this.functions.toArray(new SpawnEntityFunction[0]);
        }

        public T setWeight(int pWeight) {
            this.weight = pWeight;
            return (T)((Builder)this.getThis());
        }

        public T setQuality(int pQuality) {
            this.quality = pQuality;
            return (T)((Builder)this.getThis());
        }
    }
}

