/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.io.serialization.ExtraJsonSerializers;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class MobPropertiesFunction
extends SpawnEntityConditionalFunction {
    private final LootContext.EntityTarget attackTarget;
    private final boolean canPickupLoot;
    private final boolean persistenceRequired;
    private final boolean noAi;
    private final ResourceLocation lootTable;

    protected MobPropertiesFunction(LootItemCondition[] pPredicates, LootContext.EntityTarget attackTarget, boolean canPickupLoot, boolean persistenceRequired, boolean noAi, ResourceLocation lootTable) {
        super(pPredicates);
        this.attackTarget = attackTarget;
        this.canPickupLoot = canPickupLoot;
        this.persistenceRequired = persistenceRequired;
        this.noAi = noAi;
        this.lootTable = lootTable;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof Mob) {
            Mob mob = (Mob)pEntity;
            if (this.attackTarget != null) {
                Object object = pContext.m_165124_(this.attackTarget.m_79003_());
                if (object instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)object;
                    mob.m_6710_(living);
                } else {
                    KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "attack target {} was not living entity", pContext.m_165124_(this.attackTarget.m_79003_()));
                }
            }
            if (this.canPickupLoot) {
                mob.m_21553_(true);
            }
            if (this.persistenceRequired) {
                mob.m_21530_();
            }
            if (this.noAi) {
                mob.m_21557_(true);
            }
            if (this.lootTable != null) {
                mob.f_21355_ = this.lootTable;
            }
        } else {
            KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "entity {} was no mob", (Object)pEntity);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType getType() {
        return (SpawnEntityFunctionType)((Object)SpawnEntityFunctions.MOB_PROPERTIES.get());
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private LootContext.EntityTarget attackTarget;
        private boolean canPickupLoot;
        private boolean persistenceRequired;
        private boolean noAi;
        private ResourceLocation lootTable;

        public Builder setTarget(LootContext.EntityTarget target) {
            this.attackTarget = target;
            return this;
        }

        public Builder canPickupLoot() {
            this.canPickupLoot = true;
            return this;
        }

        public Builder persistenceRequired() {
            this.persistenceRequired = true;
            return this;
        }

        public Builder setLootTable(ResourceLocation lootTable) {
            this.lootTable = lootTable;
            return this;
        }

        public Builder noAi() {
            this.noAi = true;
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new MobPropertiesFunction(this.getConditions(), this.attackTarget, this.canPickupLoot, this.persistenceRequired, this.noAi, this.lootTable);
        }
    }

    public static class Serializer
    extends SpawnEntityConditionalFunction.Serializer<MobPropertiesFunction> {
        @Override
        public void serialize(JsonObject pJson, MobPropertiesFunction pFunction, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pFunction, pSerializationContext);
            if (pFunction.attackTarget != null) {
                pJson.add("attackTarget", pSerializationContext.serialize((Object)pFunction.attackTarget));
            }
            if (pFunction.canPickupLoot) {
                pJson.addProperty("canPickupLoot", Boolean.valueOf(true));
            }
            if (pFunction.persistenceRequired) {
                pJson.addProperty("persistenceRequired", Boolean.valueOf(true));
            }
            if (pFunction.noAi) {
                pJson.addProperty("noAi", Boolean.valueOf(true));
            }
        }

        @Override
        public MobPropertiesFunction deserialize(JsonObject pObject, JsonDeserializationContext pDeserializationContext, LootItemCondition[] pConditions) {
            LootContext.EntityTarget attackTarget = pObject.has("attackTarget") ? (LootContext.EntityTarget)pDeserializationContext.deserialize(pObject.get("attackTarget"), LootContext.EntityTarget.class) : null;
            boolean canPickupLoot = GsonHelper.m_13855_((JsonObject)pObject, (String)"canPickupLoot", (boolean)false);
            boolean persistenceRequired = GsonHelper.m_13855_((JsonObject)pObject, (String)"persistenceRequired", (boolean)false);
            boolean noAi = GsonHelper.m_13855_((JsonObject)pObject, (String)"noAi", (boolean)false);
            ResourceLocation lootTable = pObject.has("loot_table") ? (ResourceLocation)ExtraJsonSerializers.RL.parse((ResourceLocation)pObject.get("loot_table")) : null;
            return new MobPropertiesFunction(pConditions, attackTarget, canPickupLoot, persistenceRequired, noAi, lootTable);
        }
    }
}

