/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.collection.BiCollectors;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.helpers.CollectorHelper;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.io.serialization.JsonSerializer;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public final class SetAttributesFunction
extends SpawnEntityConditionalFunction {
    private final Pair<Attribute, Modifiers>[] data;
    private static final JsonSerializer<AttributeModifier> SERIALIZER = new JsonSerializer<AttributeModifier>(ExtraCodecs.ATTRIBUTE_MODIFIER);

    private SetAttributesFunction(LootItemCondition[] pPredicates, Pair<Attribute, Modifiers>[] data) {
        super(pPredicates);
        this.data = data;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            for (Pair<Attribute, Modifiers> pair : this.data) {
                try {
                    ((Modifiers)pair.getSecond()).apply(living.m_21051_((Attribute)pair.getFirst()));
                }
                catch (Exception e) {
                    KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "unable to apply attribute modifiers for '{}': {}", (Object)ForgeRegistries.ATTRIBUTES.getKey((Object)((Attribute)pair.getFirst())), (Object)e.getMessage());
                }
            }
        } else {
            SetAttributesFunction.logWrongType("LivingEntity", pEntity);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType getType() {
        return (SpawnEntityFunctionType)((Object)SpawnEntityFunctions.SET_ATTRIBUTES.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    private record Modifiers(AttributeModifier[] modifiers, Double base) {
        public void apply(AttributeInstance instance) {
            if (this.base != null) {
                instance.m_22100_(this.base.doubleValue());
            }
            for (AttributeModifier modifier : this.modifiers) {
                instance.m_22125_(modifier);
            }
        }

        public static Modifiers fromJson(JsonElement element) {
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                AttributeModifier[] modifiers = object.has("modifiers") ? (AttributeModifier[])JsonHelper.castToObjects(GsonHelper.m_13933_((JsonObject)object, (String)"modifiers")).map(SERIALIZER::parse).toArray(AttributeModifier[]::new) : new AttributeModifier[]{};
                Double base = object.has("base") ? Double.valueOf(GsonHelper.m_144784_((JsonObject)object, (String)"base")) : null;
                return new Modifiers(modifiers, base);
            }
            throw new JsonParseException("Modifiers data was no object");
        }

        private static AttributeModifier modifierFromJson(JsonObject element) {
            UUID uuid = element.has("uuid") ? UUID.fromString(GsonHelper.m_13906_((JsonObject)element, (String)"uuid")) : UUID.randomUUID();
            String name = GsonHelper.m_13906_((JsonObject)element, (String)"name");
            double amount = GsonHelper.m_144784_((JsonObject)element, (String)"amount");
            AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)GsonHelper.m_13906_((JsonObject)element, (String)"operation").toUpperCase());
            return new AttributeModifier(uuid, name, amount, operation);
        }

        public JsonObject toJson() {
            JsonObject object = new JsonObject();
            if (this.modifiers.length > 0) {
                JsonArray array = new JsonArray();
                for (AttributeModifier modifier : this.modifiers) {
                    array.add((JsonElement)SERIALIZER.encode(modifier));
                }
                object.add("modifiers", (JsonElement)array);
            }
            if (this.base != null) {
                object.addProperty("base", (Number)this.base);
            }
            return object;
        }
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private final Map<Attribute, ModifiersBuilder> modifiers = new HashMap<Attribute, ModifiersBuilder>();

        @Override
        protected Builder getThis() {
            return this;
        }

        public ModifiersBuilder withAttribute(Attribute attribute) {
            this.modifiers.putIfAbsent(attribute, new ModifiersBuilder());
            return this.modifiers.get(attribute);
        }

        @Override
        public SpawnEntityFunction build() {
            return new SetAttributesFunction(this.getConditions(), this.makePairs());
        }

        private Pair<Attribute, Modifiers>[] makePairs() {
            return MapStream.of(this.modifiers).mapValues(ModifiersBuilder::createModifiers).toPairArray();
        }

        public class ModifiersBuilder {
            private Double base = null;
            private final List<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();

            public ModifiersBuilder setBase(double base) {
                this.base = base;
                return this;
            }

            public ModifiersBuilder addModifier(AttributeModifier modifier) {
                this.modifiers.add(modifier);
                return this;
            }

            private Modifiers createModifiers() {
                return new Modifiers((AttributeModifier[])this.modifiers.toArray(AttributeModifier[]::new), this.base);
            }

            public Builder end() {
                return Builder.this;
            }
        }
    }

    public static class Serializer
    extends SpawnEntityConditionalFunction.Serializer<SetAttributesFunction> {
        @Override
        public void serialize(@NotNull JsonObject pJson, @NotNull SetAttributesFunction pFunction, @NotNull JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pFunction, pSerializationContext);
            pJson.add("modifiers", (JsonElement)Arrays.stream(pFunction.data).collect(CollectorHelper.toMapStream(Pair::getFirst, Pair::getSecond)).mapKeys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ATTRIBUTES).getKey(arg_0)).mapKeys(ResourceLocation::toString).mapValues(Modifiers::toJson).collect(BiCollectors.mergeJson()));
        }

        @Override
        public SetAttributesFunction deserialize(JsonObject pObject, JsonDeserializationContext pDeserializationContext, LootItemCondition[] pConditions) {
            Pair<Attribute, Modifiers>[] data = MapStream.of(GsonHelper.m_13930_((JsonObject)pObject, (String)"modifiers").asMap()).mapValues(Modifiers::fromJson).mapKeys(ResourceLocation::new).mapKeys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ATTRIBUTES).getValue(arg_0)).toPairArray();
            return new SetAttributesFunction(pConditions, data);
        }
    }
}

