/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions.core;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SpawnEntityConditionalFunction
implements SpawnEntityFunction {
    protected final LootItemCondition[] predicates;
    private final Predicate<LootContext> compositePredicates;

    protected SpawnEntityConditionalFunction(LootItemCondition[] pPredicates) {
        this.predicates = pPredicates;
        this.compositePredicates = LootItemConditions.m_81834_((Predicate[])pPredicates);
    }

    protected static void logWrongType(String name, Entity entity) {
        KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "{} was no {}", (Object)entity, (Object)name);
    }

    @Override
    public final Entity apply(Entity pEntity, SpawnContext pContext) {
        return this.compositePredicates.test(pContext) ? this.run(pEntity, pContext) : pEntity;
    }

    protected abstract Entity run(Entity var1, SpawnContext var2);

    public void m_6169_(ValidationContext pContext) {
        SpawnEntityFunction.super.m_6169_(pContext);
        for (int i = 0; i < this.predicates.length; ++i) {
            this.predicates[i].m_6169_(pContext.m_79365_(".conditions[" + i + "]"));
        }
    }

    protected static Builder<?> simpleBuilder(Function<LootItemCondition[], SpawnEntityFunction> pConstructor) {
        return new DummyBuilder(pConstructor);
    }

    static final class DummyBuilder
    extends Builder<DummyBuilder> {
        private final Function<LootItemCondition[], SpawnEntityFunction> constructor;

        public DummyBuilder(Function<LootItemCondition[], SpawnEntityFunction> pConstructor) {
            this.constructor = pConstructor;
        }

        @Override
        protected DummyBuilder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return this.constructor.apply(this.getConditions());
        }
    }

    public static abstract class Serializer<T extends SpawnEntityConditionalFunction>
    implements net.minecraft.world.level.storage.loot.Serializer<T> {
        public void serialize(JsonObject pJson, T pFunction, JsonSerializationContext pSerializationContext) {
            if (!ArrayUtils.isEmpty((Object[])((SpawnEntityConditionalFunction)pFunction).predicates)) {
                pJson.add("conditions", pSerializationContext.serialize((Object)((SpawnEntityConditionalFunction)pFunction).predicates));
            }
        }

        public final T deserialize(JsonObject pJson, JsonDeserializationContext pSerializationContext) {
            LootItemCondition[] alootitemcondition = (LootItemCondition[])GsonHelper.m_13845_((JsonObject)pJson, (String)"conditions", (Object)new LootItemCondition[0], (JsonDeserializationContext)pSerializationContext, LootItemCondition[].class);
            return this.deserialize(pJson, pSerializationContext, alootitemcondition);
        }

        public abstract T deserialize(JsonObject var1, JsonDeserializationContext var2, LootItemCondition[] var3);
    }

    public static abstract class Builder<T extends Builder<T>>
    implements SpawnEntityFunction.Builder,
    ConditionUserBuilder<T> {
        private final List<LootItemCondition> conditions = Lists.newArrayList();

        public T when(LootItemCondition.Builder p_80694_) {
            this.conditions.add(p_80694_.m_6409_());
            return this.getThis();
        }

        public final T unwrap() {
            return this.getThis();
        }

        protected abstract T getThis();

        protected LootItemCondition[] getConditions() {
            return this.conditions.toArray(new LootItemCondition[0]);
        }
    }
}

