/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.kapitencraft.kap_lib.helpers.ExtraStreamCodecs;
import net.kapitencraft.kap_lib.registry.ExtraParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class LightningParticleOptions
extends ParticleType<LightningParticleOptions>
implements ParticleOptions {
    private static final MapCodec<LightningParticleOptions> CODEC = RecordCodecBuilder.mapCodec(lightningParticleOptionsInstance -> lightningParticleOptionsInstance.group((App)Vec3.CODEC.fieldOf("start").forGetter(LightningParticleOptions::getStart), (App)Vec3.CODEC.fieldOf("end").forGetter(LightningParticleOptions::getEnd), (App)Codec.INT.fieldOf("segments").forGetter(LightningParticleOptions::getSegments), (App)Codec.INT.fieldOf("lifetime").forGetter(LightningParticleOptions::getLifetime), (App)Codec.FLOAT.fieldOf("displacement").forGetter(LightningParticleOptions::getDisplacement), (App)Codec.FLOAT.fieldOf("width").forGetter(LightningParticleOptions::getWidth)).apply((Applicative)lightningParticleOptionsInstance, LightningParticleOptions::new));
    private static final StreamCodec<FriendlyByteBuf, LightningParticleOptions> STREAM_CODEC = StreamCodec.composite(ExtraStreamCodecs.VEC_3, LightningParticleOptions::getStart, ExtraStreamCodecs.VEC_3, LightningParticleOptions::getEnd, (StreamCodec)ByteBufCodecs.INT, LightningParticleOptions::getSegments, (StreamCodec)ByteBufCodecs.INT, LightningParticleOptions::getLifetime, (StreamCodec)ByteBufCodecs.FLOAT, LightningParticleOptions::getDisplacement, (StreamCodec)ByteBufCodecs.FLOAT, LightningParticleOptions::getWidth, LightningParticleOptions::new);
    private final Vec3 start;
    private final Vec3 end;
    private final int segments;
    private final int lifetime;
    private final float displacement;
    private final float width;

    public LightningParticleOptions(Vec3 start, Vec3 end, @Range(from=2L, to=255L) int segments, int lifetime, float displacement, float width) {
        super(true);
        this.start = start;
        this.end = end;
        this.segments = segments;
        this.lifetime = lifetime;
        this.displacement = displacement;
        this.width = width;
    }

    public Vec3 getStart() {
        return this.start;
    }

    public Vec3 getEnd() {
        return this.end;
    }

    @NotNull
    public ParticleType<?> getType() {
        return ExtraParticleTypes.LIGHTNING.get();
    }

    @NotNull
    public MapCodec<LightningParticleOptions> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, LightningParticleOptions> streamCodec() {
        return STREAM_CODEC;
    }

    public int getSegments() {
        return this.segments;
    }

    public float getDisplacement() {
        return this.displacement;
    }

    public float getWidth() {
        return this.width;
    }

    public int getLifetime() {
        return this.lifetime;
    }
}

