/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.background;

import java.util.Objects;
import net.kapitencraft.kap_lib.client.widget.background.CutoutBackground;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TextureBackground
extends CutoutBackground {
    private final ResourceLocation texture;
    private final int textureWidth;
    private final int textureHeight;

    TextureBackground(ResourceLocation texture, int textureWidth, int textureHeight) {
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    @Override
    protected void renderCutout(GuiGraphics graphics, int x, int y, int width, int height, float offsetX, float offsetY) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 0.0f);
        ResourceLocation resourcelocation = Objects.requireNonNullElse(this.texture, TextureManager.INTENTIONAL_MISSING_TEXTURE);
        int xBackGround = Mth.floor((float)offsetX);
        int yBackGround = Mth.floor((float)offsetY);
        int backgroundXStart = xBackGround % this.textureWidth;
        int backgroundYStart = yBackGround % this.textureHeight;
        for (int i1 = -1; i1 <= 15; ++i1) {
            for (int j1 = -1; j1 <= 8; ++j1) {
                graphics.blit(resourcelocation, backgroundXStart + this.textureWidth * i1, backgroundYStart + this.textureHeight * j1, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
            }
        }
        graphics.pose().popPose();
    }
}

