/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.collection.DoubleMap;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.item.combat.armor.AbstractArmorItem;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BonusProvider
extends ItemTagsProvider {
    private final PackOutput output;
    private final String modId;
    private final Map<String, SetBuilder> setBuilders = new HashMap<String, SetBuilder>();
    private final DoubleMap<Item, String, ItemBuilder> itemBuilders = DoubleMap.create();

    public BonusProvider(PackOutput output, String modId, CompletableFuture<HolderLookup.Provider> pLookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, pLookupProvider, CompletableFuture.completedFuture(TagsProvider.TagLookup.empty()), modId, existingFileHelper);
        this.output = output;
        this.modId = modId;
    }

    protected SetBuilder createSetBonus(String name) {
        this.setBuilders.putIfAbsent(name, new SetBuilder(name));
        return this.setBuilders.get(name);
    }

    protected ItemBuilder createItemBonus(Item item, String name) {
        ItemBuilder builder = new ItemBuilder();
        this.itemBuilders.putIfAbsent(item, name, builder);
        return builder;
    }

    protected ItemBuilder createItemBonus(Supplier<? extends Item> supplier, String name) {
        return this.createItemBonus(supplier.get(), name);
    }

    public abstract void register();

    @ApiStatus.Internal
    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
        this.register();
        List<CompletableFuture> setExecutors = MapStream.of(this.setBuilders).mapToSimple((key, builder) -> {
            Path path = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("bonuses").resolve("set").resolve(key + ".json");
            return DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)this.saveSet((SetBuilder)builder), (Path)path);
        }).toList();
        ArrayList itemExecutors = new ArrayList();
        this.itemBuilders.forAllEach((item, location, itemBuilder) -> {
            Path path = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("bonuses").resolve(location + ".json");
            itemExecutors.add(DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)this.saveItem((Item)item, (ItemBuilder)itemBuilder), (Path)path));
        });
        return CompletableFuture.allOf(CompletableFuture.allOf((CompletableFuture[])setExecutors.toArray(CompletableFuture[]::new)), CompletableFuture.allOf((CompletableFuture[])itemExecutors.toArray(CompletableFuture[]::new)), super.run(pOutput));
    }

    private <T extends Bonus<T>> JsonObject saveItem(Item item, ItemBuilder itemBuilder) {
        Bonus<?> bonus = itemBuilder.getBonus();
        JsonObject main = new JsonObject();
        if (itemBuilder.isHidden()) {
            main.addProperty("hidden", Boolean.valueOf(true));
        }
        if (bonus != null) {
            DataResult result = Bonus.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, bonus);
            result.resultOrPartial(e -> LOGGER.warn("unable to save item loader for item {}: {}", (Object)BuiltInRegistries.ITEM.getKey((Object)item), e)).ifPresent(e -> main.add("bonus", e));
        }
        if (item != null) {
            main.addProperty("item", Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item), "unknown item with class: " + item.getClass().getCanonicalName()).toString());
        }
        main.addProperty("type", Objects.requireNonNull(ExtraRegistries.BONUS_SERIALIZER.getKey(itemBuilder.bonus.getSerializer()), "unknown bonus with class: " + itemBuilder.bonus.getClass().getCanonicalName()).toString());
        return main;
    }

    private JsonObject saveSet(SetBuilder builder) {
        JsonObject main = this.saveItem(null, builder);
        JsonArray array = new JsonArray();
        for (EquipmentSlot slot : builder.equipmentContent.keySet()) {
            array.add(slot.getName());
        }
        main.add("equipment_slots", (JsonElement)array);
        JsonArray wearables = new JsonArray();
        for (WearableSlot slot : builder.wearableContent.keySet()) {
            wearables.add(ExtraRegistries.WEARABLE_SLOTS.getKey((Object)slot).toString());
        }
        main.add("wearable_slots", (JsonElement)wearables);
        return main;
    }

    @NotNull
    public String getName() {
        return "Bonuses of '" + this.modId + "'";
    }

    protected void addTags(@NotNull HolderLookup.Provider pProvider) {
        this.setBuilders.values().forEach(setBuilder -> {
            setBuilder.equipmentContent.values().forEach(setSlotBuilder -> this.builders.put(setSlotBuilder.key.location(), setSlotBuilder.builder));
            setBuilder.wearableContent.values().forEach(setSlotBuilder -> this.builders.put(setSlotBuilder.key.location(), setSlotBuilder.builder));
        });
    }

    protected class SetBuilder
    extends ItemBuilder {
        private final Map<EquipmentSlot, SetSlotBuilder> equipmentContent = new HashMap<EquipmentSlot, SetSlotBuilder>();
        private final Map<WearableSlot, SetSlotBuilder> wearableContent = new HashMap<WearableSlot, SetSlotBuilder>();
        private final String name;

        protected SetBuilder(String name) {
            this.name = name;
        }

        public SetBuilder slot(EquipmentSlot slot, Consumer<SetSlotBuilder> builder) {
            this.equipmentContent.putIfAbsent(slot, (SetSlotBuilder)Util.make((Object)new SetSlotBuilder(ResourceLocation.fromNamespaceAndPath((String)BonusProvider.this.modId, (String)("set/" + this.name + "/" + slot.getName()))), builder));
            return this;
        }

        public SetBuilder slot(EquipmentSlot slot, Item item) {
            return this.slot(slot, (SetSlotBuilder setSlotBuilder) -> setSlotBuilder.add(item));
        }

        public SetBuilder slot(EquipmentSlot slot, Supplier<? extends Item> supplier) {
            return this.slot(slot, supplier.get());
        }

        public SetBuilder armor(Map<ArmorItem.Type, ? extends Supplier<? extends AbstractArmorItem>> armors) {
            for (Map.Entry<ArmorItem.Type, ? extends Supplier<? extends AbstractArmorItem>> piece : armors.entrySet()) {
                EquipmentSlot slot = piece.getKey().getSlot();
                this.slot(slot, piece.getValue());
            }
            return this;
        }

        public SetBuilder slot(WearableSlot slot, Consumer<SetSlotBuilder> builder) {
            ResourceLocation location = ExtraRegistries.WEARABLE_SLOTS.getKey((Object)slot);
            if (location == null) {
                throw new IllegalArgumentException("unregistered wearable slot detected!");
            }
            this.wearableContent.putIfAbsent(slot, (SetSlotBuilder)Util.make((Object)new SetSlotBuilder(ResourceLocation.fromNamespaceAndPath((String)BonusProvider.this.modId, (String)("set/" + this.name + "/wearable/" + location.getNamespace() + "/" + location.getPath()))), builder));
            return this;
        }

        public SetBuilder slot(Holder<WearableSlot> slot, Item item) {
            return this.slot(slot, (SetSlotBuilder setSlotBuilder) -> setSlotBuilder.add(item));
        }

        public SetBuilder slot(Holder<WearableSlot> slot, Supplier<? extends Item> supplier) {
            return this.slot(slot, supplier.get());
        }

        public SetBuilder slot(Holder<WearableSlot> slot, Consumer<SetSlotBuilder> builder) {
            if (!slot.isBound()) {
                throw new IllegalArgumentException("unregistered wearable slot detected!");
            }
            ResourceLocation location = slot.getKey().location();
            this.wearableContent.putIfAbsent((WearableSlot)slot.value(), (SetSlotBuilder)Util.make((Object)new SetSlotBuilder(ResourceLocation.fromNamespaceAndPath((String)BonusProvider.this.modId, (String)("set/" + this.name + "/wearable/" + location.getNamespace() + "/" + location.getPath()))), builder));
            return this;
        }

        public SetBuilder slot(WearableSlot slot, Item item) {
            return this.slot(slot, (SetSlotBuilder setSlotBuilder) -> setSlotBuilder.add(item));
        }

        public SetBuilder slot(WearableSlot slot, Supplier<? extends Item> supplier) {
            return this.slot(slot, supplier.get());
        }

        @Override
        public SetBuilder setHidden() {
            return (SetBuilder)super.setHidden();
        }

        @Override
        public SetBuilder setBonus(Bonus<?> bonus) {
            return (SetBuilder)super.setBonus(bonus);
        }

        private Map<EquipmentSlot, SetSlotBuilder> getEquipmentContent() {
            return this.equipmentContent;
        }
    }

    protected static class ItemBuilder {
        private Bonus<?> bonus;
        private boolean hidden;

        protected ItemBuilder() {
        }

        public ItemBuilder setHidden() {
            this.hidden = true;
            return this;
        }

        public ItemBuilder setBonus(Bonus<?> bonus) {
            this.bonus = bonus;
            return this;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        protected Bonus<?> getBonus() {
            return Objects.requireNonNull(this.bonus, "found builder without bonus!");
        }
    }

    protected static class SetSlotBuilder {
        private final TagKey<Item> key;
        private final TagBuilder builder;

        protected SetSlotBuilder(ResourceLocation location) {
            this.key = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
            this.builder = new TagBuilder();
        }

        public SetSlotBuilder add(Item item) {
            this.builder.add(TagEntry.element((ResourceLocation)item.builtInRegistryHolder().key().location()));
            return this;
        }

        public SetSlotBuilder addAll(Item ... items) {
            for (Item item : items) {
                this.add(item);
            }
            return this;
        }

        @NotNull
        public SetSlotBuilder addTag(@NotNull TagKey<Item> tagKey) {
            this.builder.addTag(tagKey.location());
            return this;
        }
    }
}

