/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.abstracts;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.io.serialization.NbtSerializer;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.ApiStatus;

public interface EnchantmentCountEffect {
    public static final Codec<EnchantmentCountEffect> CODEC = ExtraRegistries.ENCHANTMENT_COUNT_EFFECTS.byNameCodec().dispatch(EnchantmentCountEffect::codec, Function.identity());
    public static final Codec<Map<UUID, Integer>> DATA_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.INT);
    public static final NbtSerializer<Map<UUID, Integer>> SERIALIZER = new NbtSerializer<Map>(DATA_CODEC, HashMap::new);

    @ApiStatus.Internal
    default public String mapName(Holder<Enchantment> holder) {
        return Objects.requireNonNull(holder.getKey(), "unknown enchantment").location().toString();
    }

    public CountType countType();

    public int getCountAmount(int var1);

    default public float execute(Holder<Enchantment> holder, int level, EnchantedItemInUse item, LivingEntity attacker, LivingEntity attacked, float damageAmount, DamageSource source, float attackStrenghtScale) {
        String mapName;
        CompoundTag attackerTag = IOHelper.getOrCreateTag(attacker.getPersistentData(), "CountEnchantment");
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>((Map)SERIALIZER.parse((Map<UUID, Integer>)(attackerTag.contains(mapName = this.mapName(holder), 10) ? attackerTag.get(mapName) : new CompoundTag())));
        map.putIfAbsent(attacked.getUUID(), 1);
        int i = (Integer)map.get(attacked.getUUID());
        if (i >= this.getCountAmount(level)) {
            if (this.countType() != CountType.EXCEPT) {
                damageAmount = this.mainExecute(level, item.itemStack(), attacker, attacked, damageAmount, 0, source, attackStrenghtScale);
            }
            i = this.countType() == CountType.ONCE ? -1 : 1;
        } else if (i >= 0) {
            if (this.countType() != CountType.NORMAL) {
                damageAmount = this.mainExecute(level, item.itemStack(), attacker, attacked, damageAmount, i, source, attackStrenghtScale);
            }
            ++i;
        }
        map.put(attacked.getUUID(), i);
        attackerTag.put(mapName, (Tag)SERIALIZER.encode(map));
        return damageAmount;
    }

    default public float tryExecute(Holder<Enchantment> holder, int level, EnchantedItemInUse enchanted, LivingEntity attacker, LivingEntity attacked, float damage, DamageSource source) {
        float attackStrengthScale = 1.0f;
        if (attacker instanceof Player) {
            Player p = (Player)attacker;
            attackStrengthScale = p.getAttackStrengthScale(0.0f);
        }
        return this.execute(holder, level, enchanted, attacker, attacked, damage, source, attackStrengthScale);
    }

    public float mainExecute(int var1, ItemStack var2, LivingEntity var3, LivingEntity var4, float var5, int var6, DamageSource var7, float var8);

    public MapCodec<? extends EnchantmentCountEffect> codec();

    public static enum CountType {
        NORMAL,
        EXCEPT,
        ONCE;

    }
}

