/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public interface AttributeHelper {
    public static double getExperienceScale(Player player) {
        double wisdom = player.getAttributeValue(ExtraAttributes.WISDOM);
        return 1.0 + wisdom / 100.0;
    }

    public static double getSaveAttributeValue(Holder<Attribute> attribute, @Nullable LivingEntity living) {
        if (living != null && living.getAttribute(attribute) != null) {
            return living.getAttributeValue(attribute);
        }
        return 0.0;
    }

    public static double getAttributeValue(@Nullable AttributeInstance instance, double baseValue) {
        if (instance == null) {
            return baseValue;
        }
        double d0 = baseValue + instance.getBaseValue();
        for (AttributeModifier attributemodifier : instance.getModifiers(AttributeModifier.Operation.ADD_VALUE).values()) {
            d0 += attributemodifier.amount();
        }
        double d1 = d0;
        for (AttributeModifier attributeModifier1 : instance.getModifiers(AttributeModifier.Operation.ADD_MULTIPLIED_BASE).values()) {
            d1 += d0 * attributeModifier1.amount();
        }
        for (AttributeModifier attributeModifier2 : instance.getModifiers(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).values()) {
            d1 *= 1.0 + attributeModifier2.amount();
        }
        return ((Attribute)instance.getAttribute().value()).sanitizeValue(d1);
    }
}

