/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.bonus.type;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.UnaryOperator;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.ExtraStreamCodecs;
import net.kapitencraft.kap_lib.io.serialization.RegistrySerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.item.modifier_display.DisplayExtension;
import net.kapitencraft.kap_lib.item.modifier_display.EquipmentDisplayExtension;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.Nullable;

public class AttributeModifiersBonus
implements Bonus<AttributeModifiersBonus>,
EquipmentDisplayExtension {
    private static final Codec<Multimap<Holder<Attribute>, AttributeModifier>> ENTRIES_CODEC = Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)AttributeModifier.CODEC.listOf()).xmap(CollectionHelper::fromListMap, CollectionHelper::fromMultimap);
    private static final MapCodec<AttributeModifiersBonus> CODEC = RecordCodecBuilder.mapCodec(attributeModifiersBonusInstance -> attributeModifiersBonusInstance.group((App)ENTRIES_CODEC.fieldOf("entries").forGetter(AttributeModifiersBonus::getModifiers), (App)DisplayExtension.Type.CODEC.optionalFieldOf("bracket_type", (Object)DisplayExtension.Type.NONE).forGetter(AttributeModifiersBonus::getType), (App)ExtraCodecs.EFFECT_SERIALIZING_STYLE.optionalFieldOf("style", (Object)Style.EMPTY).forGetter(AttributeModifiersBonus::getStyle)).apply((Applicative)attributeModifiersBonusInstance, AttributeModifiersBonus::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttributeModifiersBonus> STREAM_CODEC = StreamCodec.composite(ExtraStreamCodecs.multimap(ByteBufCodecs.holderRegistry((ResourceKey)Registries.ATTRIBUTE), AttributeModifier.STREAM_CODEC), AttributeModifiersBonus::getModifiers, DisplayExtension.Type.STREAM_CODEC, AttributeModifiersBonus::getType, (StreamCodec)Style.Serializer.TRUSTED_STREAM_CODEC, AttributeModifiersBonus::getStyle, AttributeModifiersBonus::new);
    public static final RegistrySerializer<AttributeModifiersBonus> SERIALIZER = new RegistrySerializer<AttributeModifiersBonus>(CODEC, STREAM_CODEC);
    private final Multimap<Holder<Attribute>, AttributeModifier> modifiers;
    private final DisplayExtension.Type type;
    private final Style style;

    public AttributeModifiersBonus(Multimap<Holder<Attribute>, AttributeModifier> modifiers, DisplayExtension.Type type, Style style) {
        this.modifiers = modifiers;
        this.type = type;
        this.style = style;
    }

    private Multimap<Holder<Attribute>, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public RegistrySerializer<AttributeModifiersBonus> getSerializer() {
        return SERIALIZER;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> getModifiers(LivingEntity living) {
        return this.modifiers;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ResourceLocation getModifiersLocation() {
        return null;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public DisplayExtension.Type getType() {
        return this.type;
    }

    public static class Builder {
        private final Multimap<Holder<Attribute>, AttributeModifier> modifiers = HashMultimap.create();
        private DisplayExtension.Type type = DisplayExtension.Type.NONE;
        private Style style = Style.EMPTY;

        public Builder addModifier(Holder<Attribute> attribute, AttributeModifier modifier) {
            this.modifiers.put(attribute, (Object)modifier);
            return this;
        }

        public Builder addModifier(Holder<Attribute> attribute, ResourceLocation name, double amount, AttributeModifier.Operation operation) {
            return this.addModifier(attribute, new AttributeModifier(name, amount, operation));
        }

        public Builder setBracketType(DisplayExtension.Type type) {
            this.type = type;
            return this;
        }

        public Builder setDisplayStyle(UnaryOperator<Style> style) {
            this.style = (Style)style.apply(Style.EMPTY);
            return this;
        }

        public AttributeModifiersBonus build() {
            return new AttributeModifiersBonus((Multimap<Holder<Attribute>, AttributeModifier>)ImmutableMultimap.copyOf(this.modifiers), this.type, this.style);
        }
    }
}

