/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.loot_table.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.kapitencraft.kap_lib.item.loot_table.LootContextReader;
import net.kapitencraft.kap_lib.item.loot_table.conditions.BaseCondition;
import net.kapitencraft.kap_lib.registry.ExtraLootItemConditions;
import net.kapitencraft.kap_lib.util.Reference;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagKeyCondition
extends BaseCondition {
    private static final TagKeyCondition EMPTY = new TagKeyCondition(null, "", null);
    public static final MapCodec<TagKeyCondition> CODEC = RecordCodecBuilder.mapCodec(tagKeyConditionInstance -> tagKeyConditionInstance.group((App)Type.CODEC.fieldOf("type").forGetter(TagKeyCondition::type), (App)Codec.STRING.fieldOf("id").forGetter(TagKeyCondition::getId), (App)Codec.STRING.optionalFieldOf("target").forGetter(TagKeyCondition::makeCodecTarget)).apply((Applicative)tagKeyConditionInstance, TagKeyCondition::fromCodec));
    private final String id;
    private final Type type;
    @Nullable
    private final LootContext.EntityTarget target;

    private Optional<String> makeCodecTarget() {
        return this.target == null ? Optional.empty() : Optional.of(this.target.getName());
    }

    public static TagKeyCondition fromCodec(Type type, String tagId, Optional<String> entityTarget) {
        return new TagKeyCondition(type, tagId, TagKeyCondition.of(entityTarget));
    }

    @Nullable
    private static LootContext.EntityTarget of(Optional<String> optional) {
        return optional.map(LootContext.EntityTarget::getByName).orElse(null);
    }

    public TagKeyCondition(Type type, String tagId, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LootContext.EntityTarget target) {
        this.type = type;
        this.id = tagId;
        this.target = target;
    }

    public Type type() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public LootItemConditionType getType() {
        return (LootItemConditionType)ExtraLootItemConditions.TAG_KEY.value();
    }

    public boolean test(LootContext context) {
        if (this == EMPTY) {
            return false;
        }
        Reference<Boolean> reference = Reference.of(false);
        switch (this.type.ordinal()) {
            case 0: 
            case 2: {
                LootContextReader.simple(context, Entity.class, this.target.getParam()).ifPresent(entity -> {
                    if (this.type == Type.ENTITY) {
                        reference.setValue(entity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)this.id))));
                    } else {
                        Boolean bl;
                        if (entity instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity;
                            bl = living.getMainHandItem().is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)this.id)));
                        } else {
                            bl = false;
                        }
                        reference.setValue(bl);
                    }
                });
                break;
            }
            case 1: {
                LootContextReader.simple(context, BlockState.class, LootContextParams.BLOCK_STATE).ifPresent(state -> reference.setValue(state.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)this.id)))));
            }
        }
        return reference.getValue();
    }

    public static enum Type implements StringRepresentable
    {
        ENTITY("entities"),
        BLOCK("blocks"),
        ITEM("items"),
        EMPTY("empty");

        public static final Codec<Type> CODEC;
        private final String name;

        public boolean is(LootContext context) {
            return context.getQueriedLootTableId().getPath().contains(this.name);
        }

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

