/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.modifier_display;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.kapitencraft.kap_lib.event.ModEventFactory;
import net.kapitencraft.kap_lib.event.custom.client.RegisterItemModifiersDisplayExtensionsEvent;
import net.kapitencraft.kap_lib.item.modifier_display.EquipmentDisplayExtension;
import net.kapitencraft.kap_lib.item.modifier_display.WearableDisplayExtension;
import net.minecraft.world.item.ItemStack;

public class ModifierDisplayManager {
    private static final List<Function<ItemStack, EquipmentDisplayExtension>> equipmentProviders = new ArrayList<Function<ItemStack, EquipmentDisplayExtension>>();
    private static final List<Function<ItemStack, WearableDisplayExtension>> wearableProviders = new ArrayList<Function<ItemStack, WearableDisplayExtension>>();

    public static void init() {
        RegisterItemModifiersDisplayExtensionsEvent event = new RegisterItemModifiersDisplayExtensionsEvent(equipmentProviders, wearableProviders);
        ModEventFactory.fireModEvent(event);
    }

    public static ExtensionData getExtensions(ItemStack obj) {
        ArrayList<EquipmentDisplayExtension> equipment = new ArrayList<EquipmentDisplayExtension>();
        for (Function<ItemStack, EquipmentDisplayExtension> provider : equipmentProviders) {
            Optional.ofNullable(provider.apply(obj)).ifPresent(equipment::add);
        }
        ArrayList<WearableDisplayExtension> wearable = new ArrayList<WearableDisplayExtension>();
        for (Function<ItemStack, WearableDisplayExtension> provider : wearableProviders) {
            Optional.ofNullable(provider.apply(obj)).ifPresent(wearable::add);
        }
        return new ExtensionData(equipment, wearable);
    }

    public record ExtensionData(List<EquipmentDisplayExtension> equipmentProviders, List<WearableDisplayExtension> wearableProviders) {
    }
}

