/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.registry;

import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.util.attribute.BaseAttributeLocations;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public interface ExtraAttributes {
    public static final DeferredRegister<Attribute> REGISTRY = KapLibMod.registry(Registries.ATTRIBUTE);
    public static final Holder<Attribute> DODGE = ExtraAttributes.register("dodge", 0.0, 0.0, 100.0, null);
    public static final Holder<Attribute> MAGIC_DEFENCE = ExtraAttributes.register0Max("magic_defence", 0.0, null);
    public static final Holder<Attribute> TRUE_DEFENCE = ExtraAttributes.register0Max("true_defence", 0.0, null);
    public static final Holder<Attribute> DOUBLE_JUMP = ExtraAttributes.register("double_jump", 0.0, 0.0, 20.0, null);
    public static final Holder<Attribute> VITALITY = ExtraAttributes.register0Max("vitality", 0.0, null);
    public static final Holder<Attribute> BONUS_ATTACK_SPEED = ExtraAttributes.register("bonus_attack_speed", 0.0, 0.0, 100.0, BaseAttributeLocations.BONUS_ATTACK_SPEED);
    public static final Holder<Attribute> STRENGTH = ExtraAttributes.register0Max("strength", 0.0, BaseAttributeLocations.STRENGTH);
    public static final Holder<Attribute> CRIT_DAMAGE = ExtraAttributes.register0Max("crit_damage", 50.0, BaseAttributeLocations.CRIT_DAMAGE);
    public static final Holder<Attribute> CRIT_CHANCE = ExtraAttributes.register("crit_chance", 0.0, 0.0, 100.0, BaseAttributeLocations.CRIT_CHANCE);
    public static final Holder<Attribute> FEROCITY = ExtraAttributes.register("ferocity", 0.0, 0.0, 500.0, BaseAttributeLocations.FEROCITY);
    public static final Holder<Attribute> INTELLIGENCE = ExtraAttributes.register0Max("intelligence", 0.0, BaseAttributeLocations.INTELLIGENCE);
    public static final Holder<Attribute> ABILITY_DAMAGE = ExtraAttributes.register0Max("ability_damage", 0.0, BaseAttributeLocations.ABILITY_DAMAGE);
    public static final Holder<Attribute> RANGED_DAMAGE = ExtraAttributes.register("ranged_damage", 0.0, 0.0, 100.0, BaseAttributeLocations.RANGED_DAMAGE);
    public static final Holder<Attribute> DRAW_SPEED = ExtraAttributes.register("draw_speed", 100.0, 0.0, 1000.0, BaseAttributeLocations.DRAW_SPEED);
    public static final Holder<Attribute> PROJECTILE_SPEED = ExtraAttributes.register("projectile_speed", 0.0, 0.0, 10000.0, BaseAttributeLocations.PROJECTILE_SPEED);
    public static final Holder<Attribute> PRISTINE = ExtraAttributes.register("pristine", 0.0, 0.0, 400.0, BaseAttributeLocations.PRISTINE);
    public static final Holder<Attribute> MINING_FORTUNE = ExtraAttributes.register0Max("mining_fortune", 0.0, BaseAttributeLocations.MINING_FORTUNE);
    public static final Holder<Attribute> COOLDOWN_REDUCTION = ExtraAttributes.registerNegative("cooldown_reduction", 0.0, 0.0, 100.0, BaseAttributeLocations.COOLDOWN_REDUCTION);
    public static final Holder<Attribute> LIVE_STEAL = ExtraAttributes.register("live_steal", 0.0, 0.0, 10.0, BaseAttributeLocations.LIVE_STEAL);
    public static final Holder<Attribute> ARMOR_SHREDDER = ExtraAttributes.register("armor_shredder", 0.0, 0.0, 100.0, BaseAttributeLocations.ARMOR_SHREDDER);
    public static final Holder<Attribute> FISHING_SPEED = ExtraAttributes.register0Max("fishing_speed", 0.0, BaseAttributeLocations.FISHING_SPEED);
    public static final Holder<Attribute> WISDOM = ExtraAttributes.register("wisdom", 0.0, -100.0, 10000.0, BaseAttributeLocations.WISDOM);
    public static final Holder<Attribute> MAX_MANA = ExtraAttributes.register0Max("max_mana", 100.0, null);
    public static final Holder<Attribute> MANA = ExtraAttributes.register0Max("mana", 100.0, null);
    public static final Holder<Attribute> MANA_COST = ExtraAttributes.registerNegative("mana_cost", 0.0, 0.0, 100000.0, BaseAttributeLocations.MANA_COST);
    public static final Holder<Attribute> MANA_REGEN = ExtraAttributes.register0Max("mana_regen", 0.0, null);

    private static Holder<Attribute> register(String name, double initValue, double minValue, double maxValue, final @Nullable ResourceLocation baseLocation) {
        return REGISTRY.register("generic." + name, () -> new RangedAttribute("generic." + name, initValue, minValue, maxValue){

            @Nullable
            public ResourceLocation getBaseId() {
                return baseLocation;
            }
        }.setSyncable(true));
    }

    private static Holder<Attribute> registerNegative(String name, double initValue, double minValue, double maxValue, final ResourceLocation baseId) {
        return REGISTRY.register("generic." + name, () -> new RangedAttribute("generic." + name, initValue, minValue, maxValue){

            @Nullable
            public ResourceLocation getBaseId() {
                return baseId;
            }
        }.setSentiment(Attribute.Sentiment.NEGATIVE).setSyncable(true));
    }

    private static Holder<Attribute> register0Max(String name, double initValue, ResourceLocation baseLocation) {
        return ExtraAttributes.register(name, initValue, 0.0, Double.MAX_VALUE, baseLocation);
    }
}

