/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class MobPropertiesFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<MobPropertiesFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)LootContext.EntityTarget.CODEC.optionalFieldOf("attackTarget").forGetter(f -> Optional.ofNullable(f.attackTarget)), (App)Codec.BOOL.optionalFieldOf("canPickupLoot", (Object)false).forGetter(f -> f.canPickupLoot), (App)Codec.BOOL.optionalFieldOf("persistenceRequired", (Object)false).forGetter(f -> f.persistenceRequired), (App)Codec.BOOL.optionalFieldOf("noAi", (Object)false).forGetter(f -> f.noAi), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).optionalFieldOf("lootTable").forGetter(f -> Optional.ofNullable(f.lootTable))).and(MobPropertiesFunction.commonFields(i).t1()).apply((Applicative)i, MobPropertiesFunction::new));
    private final LootContext.EntityTarget attackTarget;
    private final boolean canPickupLoot;
    private final boolean persistenceRequired;
    private final boolean noAi;
    private final ResourceKey<LootTable> lootTable;

    protected MobPropertiesFunction(Optional<LootContext.EntityTarget> attackTarget, boolean canPickupLoot, boolean persistenceRequired, boolean noAi, Optional<ResourceKey<LootTable>> lootTable, List<LootItemCondition> pPredicates) {
        this(attackTarget.orElse(null), canPickupLoot, persistenceRequired, noAi, (ResourceKey<LootTable>)((ResourceKey)lootTable.orElse(null)), pPredicates);
    }

    protected MobPropertiesFunction(LootContext.EntityTarget attackTarget, boolean canPickupLoot, boolean persistenceRequired, boolean noAi, ResourceKey<LootTable> lootTable, List<LootItemCondition> pPredicates) {
        super(pPredicates);
        this.attackTarget = attackTarget;
        this.canPickupLoot = canPickupLoot;
        this.persistenceRequired = persistenceRequired;
        this.noAi = noAi;
        this.lootTable = lootTable;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof Mob) {
            Mob mob = (Mob)pEntity;
            if (this.attackTarget != null) {
                Object object = pContext.getParam(this.attackTarget.getParam());
                if (object instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)object;
                    mob.setTarget(living);
                } else {
                    KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "attack target {} was not living entity", pContext.getParam(this.attackTarget.getParam()));
                }
            }
            if (this.canPickupLoot) {
                mob.setCanPickUpLoot(true);
            }
            if (this.persistenceRequired) {
                mob.setPersistenceRequired();
            }
            if (this.noAi) {
                mob.setNoAi(true);
            }
            if (this.lootTable != null) {
                mob.lootTable = this.lootTable;
            }
        } else {
            KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "entity {} was no mob", (Object)pEntity);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType<?> getType() {
        return SpawnEntityFunctions.MOB_PROPERTIES.get();
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private LootContext.EntityTarget attackTarget;
        private boolean canPickupLoot;
        private boolean persistenceRequired;
        private boolean noAi;
        private ResourceKey<LootTable> lootTable;

        public Builder setTarget(LootContext.EntityTarget target) {
            this.attackTarget = target;
            return this;
        }

        public Builder canPickupLoot() {
            this.canPickupLoot = true;
            return this;
        }

        public Builder persistenceRequired() {
            this.persistenceRequired = true;
            return this;
        }

        public Builder setLootTable(ResourceKey<LootTable> lootTable) {
            this.lootTable = lootTable;
            return this;
        }

        public Builder noAi() {
            this.noAi = true;
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new MobPropertiesFunction(this.attackTarget, this.canPickupLoot, this.persistenceRequired, this.noAi, this.lootTable, this.getConditions());
        }
    }
}

